package cn.com.duiba.activity.center.biz.remoteservice.impl.singlelottery;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryAppSpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.singlelottery.RemoteDuibaSingleLotteryServiceNew;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/18.
 */
@Service
public class RemoteDuibaSingleLotteryServiceNewImpl implements RemoteDuibaSingleLotteryServiceNew {
    @Resource
    private DuibaSingleLotteryService duibaSingleLotteryService;

    @Override
    public List<DuibaSingleLotteryDto> findAutoOff() {
        return duibaSingleLotteryService.findAutoOff();
    }

    @Override
    public DuibaSingleLotteryDto find(Long id) {
        return duibaSingleLotteryService.find(id);
    }

    @Override
    public List<DuibaSingleLotteryDto> findSingleLotteryPage(Map<String, Object> queryMap) {
        return duibaSingleLotteryService.findSingleLotteryPage(queryMap);
    }

    @Override
    public List<DuibaSingleLotteryDto> findSingleLottery(Map<String, Object> queryMap) {
        return duibaSingleLotteryService.findSingleLottery(queryMap);
    }

    @Override
    public Long findSingleLotteryPageCount(Map<String, Object> queryMap) {
        return duibaSingleLotteryService.findSingleLotteryPageCount(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaSingleLottery(Long appId) {
        return duibaSingleLotteryService.findAllDuibaSingleLottery(appId);
    }

    @Override
    public List<DuibaSingleLotteryDto> findAllByIds(List<Long> ids) {
        return duibaSingleLotteryService.findAllByIds(ids);
    }

    @Override
    public Long getCountDuibaSingleLottery(Map<String, Object> queryMap) {
        return duibaSingleLotteryService.getCountDuibaSingleLottery(queryMap);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLotteryId, appId);
    }

    @Override
    public List<SingleLotteryAppSpecifyDto> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId) {
        return duibaSingleLotteryService.findAllSpecifyByDuibaSingleLottery(duibaSingleLotteryId);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyById(Long id) {
        return duibaSingleLotteryService.findSpecifyById(id);
    }

    @Override
    public List<Long> findHasUserdSingleIds(Long itemId) {
        return duibaSingleLotteryService.findHasUserdSingleIds(itemId);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return duibaSingleLotteryService.findExtraInfoById(id);
    }

    @Override
    public int updateAutoOffDate(Long id) {
        return duibaSingleLotteryService.updateAutoOffDate(id);
    }

    @Override
    public DuibaSingleLotteryDto insert(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        duibaSingleLotteryService.insert(duibaSingleLotteryDO);
        return duibaSingleLotteryDO;
    }

    @Override
    public int update(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        return duibaSingleLotteryService.update(duibaSingleLotteryDO);
    }

    @Override
    public int reduceMainItemRemaining(Long id) {
        return duibaSingleLotteryService.reduceMainItemRemaining(id);
    }

    @Override
    public int addMainItemRemaining(Long id) {
        return duibaSingleLotteryService.addMainItemRemaining(id);
    }

    @Override
    public int reduceInciteItemRemaining(Long id) {
        return duibaSingleLotteryService.reduceInciteItemRemaining(id);
    }

    @Override
    public int addInciteItemRemaining(Long id) {
        return duibaSingleLotteryService.addInciteItemRemaining(id);
    }

    @Override
    public int updateForAdminEdit(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        return duibaSingleLotteryService.updateForAdminEdit(duibaSingleLotteryDO);
    }

    @Override
    public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryService.reduceSpecifyAppRemaining(duibaSingleLotteryId, appId);
    }

    @Override
    public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryService.addSpecifyAppRemaining(duibaSingleLotteryId, appId);
    }

    @Override
    public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryService.addSpecifyOrderCount(duibaSingleLotteryId, appId);
    }

    @Override
    public int deleteSpecify(Long id) {
        return duibaSingleLotteryService.deleteSpecify(id);
    }

    @Override
    public SingleLotteryAppSpecifyDto insertAppSpecify(SingleLotteryAppSpecifyDto singleLotteryAppSpecifyDO) {
        duibaSingleLotteryService.insertAppSpecify(singleLotteryAppSpecifyDO);
        return singleLotteryAppSpecifyDO;
    }

    @Override
    public int updateSpecifyRemaining(Long id, Integer remaining) {
        return duibaSingleLotteryService.updateSpecifyRemaining(id, remaining);
    }

    @Override
    public int addMainItemRemainingById(Long id, Integer addMainItemRemaining) {
        return duibaSingleLotteryService.addMainItemRemainingById(id, addMainItemRemaining);
    }

    @Override
    public int subMainItemRemainingById(Long id, Integer subMainItemRemaining) {
        return duibaSingleLotteryService.subMainItemRemainingById(id, subMainItemRemaining);
    }

    @Override
    public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining) {
        return duibaSingleLotteryService.addInciteItemRemainingById(id, addInciteItemRemaining);
    }

    @Override
    public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining) {
        return duibaSingleLotteryService.subInciteItemRemainingById(id, subInciteItemRemaining);
    }

    @Override
    public DuibaSingleLotteryDto findForupdate(Long id) {
        return duibaSingleLotteryService.findForupdate(id);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyForupdate(Long id) {
        return duibaSingleLotteryService.findSpecifyForupdate(id);
    }
}
