/**
 * Project Name:activity-center-biz
 * File Name:CategoryActivityService.java
 * Package Name:cn.com.duiba.activity.center.biz.service
 * Date:2016年6月8日下午4:17:12
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;

/**
 * ClassName:CategoryActivityService <br/>
 * Function: 对应表:tb_activity_category_relation. <br/>
 * Date:     2016年6月8日 下午4:17:12 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ActivityCategoryRelationService {
    
    public List<ActivityCategoryRelationEntity> findByAppCategory(long appId, long categoryId);
    
    public boolean sortActivities(List<CategoryActivityDto> activities);
    
    public boolean save(ActivityCategoryRelationEntity entity);
    
    public boolean remove(long operatingActivityId);
    
    public ActivityCategoryRelationEntity findByOperatingActivityId(long operatingActivityId);

	public List<ActivityCategoryRelationEntity> findByAppCategory(long appId,
			long categoryId, int start, int pageSize);

}

