package cn.com.duiba.activity.center.biz.service.duibaactivity.impl;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.duibaactivity.DuibaActivityDao;
import cn.com.duiba.activity.center.biz.entity.duibaactivity.DuibaActivityEntity;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/23.
 */
@Service
public class DuibaActivityServiceImpl implements DuibaActivityService {
    @Resource
    private DuibaActivityDao duibaActivityDao;

    @Override
    public int updateAutoOffDateNull(Long id) {
        return duibaActivityDao.updateAutoOffDateNull(id);
    }

    @Override
    public List<DuibaActivityDto> findPage(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaActivityDao.findPage(queryMap),DuibaActivityDto.class);
    }

    @Override
    public List<DuibaActivityDto> findDuibaActivity(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaActivityDao.findDuibaActivity(queryMap),DuibaActivityDto.class);
    }

    @Override
    public Integer findPageCount(Map<String, Object> queryMap) {
        return duibaActivityDao.findPageCount(queryMap);
    }

    @Override
    public Integer getCountDuibaActivity(Map<String, Object> queryMap) {
        return duibaActivityDao.getCountDuibaActivity(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaActivity(@Param("appId") Long appId) {
        return BeanUtils.copyList(duibaActivityDao.findAllDuibaActivity(appId),AddActivityDto.class);
    }

    @Override
    public List<DuibaActivityDto> findAllByIds(@Param("ids") List<Long> ids) {
        return BeanUtils.copyList(duibaActivityDao.findAllByIds(ids),DuibaActivityDto.class);
    }

    @Override
    public DuibaActivityDto find(Long id) {
        return BeanUtils.copy(duibaActivityDao.find(id),DuibaActivityDto.class);
    }

    @Override
    public void insert(DuibaActivityDto duibaActivityDO) {
        DuibaActivityEntity entity=new DuibaActivityEntity(true);
        BeanUtils.copy(duibaActivityDO,entity);
        duibaActivityDao.insert(entity);
        duibaActivityDO.setId(duibaActivityDO.getId());
    }

    @Override
    public void update(DuibaActivityDto duibaActivityDO) {
        duibaActivityDao.update(BeanUtils.copy(duibaActivityDO,DuibaActivityEntity.class));
    }

    @Override
    public List<DuibaActivityDto> findAutoOff() {
        return BeanUtils.copyList(duibaActivityDao.findAutoOff(),DuibaActivityDto.class);
    }


}
