package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/19.
 */
@Service
public class DuibaQuestionAnswerServiceImpl implements DuibaQuestionAnswerService {
    @Resource
    private DuibaQuestionAnswerDao duibaQuestionAnswerDao;

    @Override
    public DuibaQuestionAnswerDto find(Long id) {
        return BeanUtils.copy(duibaQuestionAnswerDao.find(id), DuibaQuestionAnswerDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findAutoOff() {
        return BeanUtils.copyList(duibaQuestionAnswerDao.findAutoOff(), DuibaQuestionAnswerDto.class);
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        return duibaQuestionAnswerDao.updateStatus(id, status);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaQuestionAnswerDao.findByIds(ids), DuibaQuestionAnswerDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return BeanUtils.copy(duibaQuestionAnswerDao.findExtraInfoById(id), ActivityExtraInfoDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaQuestionAnswerDao.findAllByIds(ids), DuibaQuestionAnswerDto.class);
    }

    @Override
    public List<AddActivityDto> findAllQuestion(Long appId) {
        return BeanUtils.copyList(duibaQuestionAnswerDao.findAllQuestion(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findByPage(Integer offset, Integer max) {
        return BeanUtils.copyList(duibaQuestionAnswerDao.findByPage(offset, max), DuibaQuestionAnswerDto.class);
    }

    @Override
    public Long findPageCount() {
        return duibaQuestionAnswerDao.findPageCount();
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return duibaQuestionAnswerDao.findPageCount(paramMap);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findByPage(Map<String, Object> paramMap) {
        return BeanUtils.copyList(duibaQuestionAnswerDao.findByPage(paramMap), DuibaQuestionAnswerDto.class);
    }

    @Override
    public int updateStatus(Long id, int status) {
        return duibaQuestionAnswerDao.updateStatus(id, status);
    }

    @Override
    public int delete(Long id) {
        return duibaQuestionAnswerDao.delete(id);
    }

    @Override
    public void insert(DuibaQuestionAnswerDto duibaQuestionAnswerDto) {
        DuibaQuestionAnswerEntity e = BeanUtils.copy(duibaQuestionAnswerDto, DuibaQuestionAnswerEntity.class);
        duibaQuestionAnswerDao.insert(e);
        duibaQuestionAnswerDto.setId(e.getId());
    }

    @Override
    public int update(DuibaQuestionAnswerDto duibaQuestionAnswerDto) {
        return duibaQuestionAnswerDao.update(BeanUtils.copy(duibaQuestionAnswerDto, DuibaQuestionAnswerEntity.class));
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        return duibaQuestionAnswerDao.updateAutoOffDateNull(id);
    }

    @Override
    public void updateSwitches(Long id, Long switches) {
        duibaQuestionAnswerDao.updateSwitches(id, switches);
    }

    @Override
	public int updateForEditActivityCategoryId(long id,Long activityCategoryId){
    	return duibaQuestionAnswerDao.updateForEditActivityCategoryId(id, activityCategoryId);
    }
}
