package cn.com.duiba.activity.center.biz.service.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;

import java.util.Date;
import java.util.List;

/**
 * hdtool_orders表的consumer维度分表,活动工具订单业务DAO
 */
public interface CreditsHdtoolOrdersService {

	//from NewHdtoolOrderSimpleDAO in credits

	/**
	 * 根据ID查询订单
	 */
	public HdtoolOrdersDto find(Long consumerId, Long id);

	/**
	 * 查询用户参与活动次数
	 */
	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户在时间段内参与活动次数
	 */
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	/**
	 * 查询用户免费参与活动次数
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户在时间段内免费参与活动次数
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	/**
	 * 查询用户中奖某奖项次数
	 */
	public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

	/**
	 * 根据活动订单ID集合查询订单信息
	 */
	public List<HdtoolOrdersDto> findByIds(Long consumerId, List<Long> ids);

	/**
	 * 根据开发者订单号查询订单
	 */
	public HdtoolOrdersDto findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId);

	/**
	 * 根据领取状态exchangeStatus查询小于endTime时间的订单
	 */
	public List<Long> findExpireOrder();

	//from NewHdtoolOrderStatusChangeDAO in credits

	/**
	 * 修改订单领奖状态为失败
	 */
	public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);

	/**
	 * 修改订单领奖状态为过期失效
	 */
	public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);

	/**
	 * 修改订单状态失败
	 */
	public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);


	/**
	 * 处理领奖
	 */
	public Integer doTakePrize(Long consumerId, Long id);

	/**
	 * 领奖创建订单失败，回滚领奖
	 */
	public Integer rollbackTakePrize(Long consumerId, Long id);

	/**
	 * 处理抽奖结果
	 */
	public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId);

	/**
	 * 福袋中奖降级处理为谢谢参与
	 * @param consumerId
	 * @param id
	 * @param appItemId
	 * @param itemId
	 * @param prizeId
	 * @param prizeName
	 * @param prizeType
	 * @param prizeFacePrice
	 * @param couponId
	 * @return
	 */
	public Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId);

	//from NewHdtoolOrderTextChangeDAO in credits

	/**
	 * 修改开发者订单号
	 */
	public int updateDeveloperBizId(Long consumerId, long id, String bizId);

	/**
	 * 修改抽奖订单主订单号
	 */
	public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum);

	/**
	 * 添加活动工具订单
	 */
	public void insert(HdtoolOrdersDto hdtoolOrdersDto);

}
