package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.CreditsHdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.HdtoolMQSend;
import cn.com.duiba.activity.center.biz.service.hdtool.CreditsHdtoolOrdersService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/30.
 */
@Service
public class CreditsHdtoolOrdersServiceImpl implements CreditsHdtoolOrdersService {
    @Resource
    private CreditsHdtoolOrdersDao creditsHdtoolOrdersDao;
    @Autowired
    private HdtoolMQSend hdtoolMQSend;

    @Override
    public HdtoolOrdersDto find(Long consumerId, Long id) {
        return BeanUtils.copy(creditsHdtoolOrdersDao.find(consumerId, id), HdtoolOrdersDto.class);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return creditsHdtoolOrdersDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return creditsHdtoolOrdersDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return creditsHdtoolOrdersDao.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return creditsHdtoolOrdersDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        return creditsHdtoolOrdersDao.countByConsumerIdAndPrizeId(consumerId, operatingActivityId, prizeId);
    }

    @Override
    public List<HdtoolOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return BeanUtils.copyList(creditsHdtoolOrdersDao.findByIds(consumerId, ids), HdtoolOrdersDto.class);
    }

    @Override
    public HdtoolOrdersDto findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId) {
        return BeanUtils.copy(creditsHdtoolOrdersDao.findByAppAndDeveloperBizId(consumerId, appId, bizId), HdtoolOrdersDto.class);
    }

    @Override
    public List<Long> findExpireOrder() {
        return creditsHdtoolOrdersDao.findExpireOrder();
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = creditsHdtoolOrdersDao.updateExchangeStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = creditsHdtoolOrdersDao.updateExchangeStatusToOverdue(consumerId, id, error4admin, error4developer, error4consumer);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = creditsHdtoolOrdersDao.updateStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        int ret = creditsHdtoolOrdersDao.doTakePrize(consumerId, id);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        int ret = creditsHdtoolOrdersDao.rollbackTakePrize(consumerId, id);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        int ret = creditsHdtoolOrdersDao.updateLotteryResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        int ret = creditsHdtoolOrdersDao.updateLotteryLuckyResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        int ret = creditsHdtoolOrdersDao.updateDeveloperBizId(consumerId, id, bizId);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        int ret = creditsHdtoolOrdersDao.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);

        hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public void insert(HdtoolOrdersDto hdtoolOrdersDto) {
        HdtoolOrdersEntity e = BeanUtils.copy(hdtoolOrdersDto, HdtoolOrdersEntity.class);
        creditsHdtoolOrdersDao.insert(e);
        hdtoolOrdersDto.setId(e.getId());
        hdtoolMQSend.hdtoolSendDataSync(hdtoolOrdersDto.getConsumerId(), hdtoolOrdersDto.getId());
    }
}
