package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/19.
 */
@Service
public class DuibaHdtoolServiceImpl implements DuibaHdtoolService {
    @Resource
    private DuibaHdtoolDao duibaHdtoolDao;

    @Override
    public List<DuibaHdtoolDto> findAutoOff() {
        return BeanUtils.copyList(duibaHdtoolDao.findAutoOff(), DuibaHdtoolDto.class);
    }

    @Override
    public DuibaHdtoolDto find(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.find(id), DuibaHdtoolDto.class);
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaHdToolsList(Map<String, Object> paramMap) {
        return BeanUtils.copyList(duibaHdtoolDao.findDuibaHdToolsList(paramMap), DuibaHdtoolDto.class);
    }

    @Override
    public Integer countDuibaHdToolsList(Map<String, Object> queryMap) {
        return duibaHdtoolDao.countDuibaHdToolsList(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaHdTools(Long appId) {
        return BeanUtils.copyList(duibaHdtoolDao.findAllDuibaHdTools(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaHdtoolDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaHdtoolDao.findAllByIds(ids), DuibaHdtoolDto.class);
    }

    @Override
    public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId) {
        return BeanUtils.copyList(duibaHdtoolDao.findOptionsByDuibaHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public Integer countOptionsByHdtoolId(Long hdtoolId) {
        return duibaHdtoolDao.countOptionsByHdtoolId(hdtoolId);
    }

    @Override
    public DuibaHdtoolOptionsDto findOptionById(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.findOptionById(id), DuibaHdtoolOptionsDto.class);
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public DuibaHdtoolOptionsDto findOptionByIdForupdate(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.findOptionByIdForupdate(id), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public List<HdtoolAppSpecifyDto> findAllSpecifyByHdToolId(Long hdToolId) {
        return BeanUtils.copyList(duibaHdtoolDao.findAllSpecifyByHdToolId(hdToolId), HdtoolAppSpecifyDto.class);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId) {
        return BeanUtils.copy(duibaHdtoolDao.findSpecifyByHdToolIdAndApp(duibaHdToolId, appId), HdtoolAppSpecifyDto.class);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyById(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.findSpecifyById(id), HdtoolAppSpecifyDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.findExtraInfoById(id), ActivityExtraInfoDto.class);
    }

    @Override
    public List<Long> findHasUserdHdIds(Long itemId) {
        return duibaHdtoolDao.findHasUserdHdIds(itemId);
    }

    @Override
    public Long getCountDuibaHdTool(Map<String, Object> queryMap) {
        return duibaHdtoolDao.getCountDuibaHdTool(queryMap);
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaToolList(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaHdtoolDao.findDuibaToolList(queryMap), DuibaHdtoolDto.class);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        return duibaHdtoolDao.updateAutoOffDateNull(id);
    }

    @Override
    public void insert(DuibaHdtoolDto duibaHdtoolDto) {
        DuibaHdtoolEntity e = BeanUtils.copy(duibaHdtoolDto, DuibaHdtoolEntity.class);
        duibaHdtoolDao.insert(e);
        duibaHdtoolDto.setId(e.getId());
    }

    @Override
    public int deleteById(Long id) {
        return duibaHdtoolDao.deleteById(id);
    }

    @Override
    public int update(DuibaHdtoolDto duibaHdtoolDto) {
        return duibaHdtoolDao.update(BeanUtils.copy(duibaHdtoolDto, DuibaHdtoolEntity.class));
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        return duibaHdtoolDao.updateStatus(id, status);
    }

    @Override
    public int decrementOptionRemaining(Long id) {
        return duibaHdtoolDao.decrementOptionRemaining(id);
    }

    @Override
    public int incrementOptionRemaining(Long id) {
        return duibaHdtoolDao.incrementOptionRemaining(id);
    }

    @Override
    public int deleteOptions(List<Long> ids) {
        return duibaHdtoolDao.deleteOptions(ids);
    }

    @Override
    public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        return duibaHdtoolDao.updateHdtoolPrize(BeanUtils.copy(duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
    }

    @Override
    public void insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        DuibaHdtoolOptionsEntity e = BeanUtils.copy(duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class);
        duibaHdtoolDao.insertHdtoolOption(e);
        duibaHdToolOptionDO.setId(e.getId());
    }

    @Override
    public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        return duibaHdtoolDao.updateHdtoolOption(BeanUtils.copy(duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
    }

    @Override
    public int deleteSpecifyById(Long id) {
        return duibaHdtoolDao.deleteSpecifyById(id);
    }

    @Override
    public void insertSpecify(HdtoolAppSpecifyDto hdtoolAppSpecifyDO) {
        HdtoolAppSpecifyEntity e = BeanUtils.copy(hdtoolAppSpecifyDO, HdtoolAppSpecifyEntity.class);
        duibaHdtoolDao.insertSpecify(e);
        hdtoolAppSpecifyDO.setId(e.getId());
    }

    @Override
	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId){
    	return duibaHdtoolDao.updateActivityCategory(duibaHdtoolId, activityCategoryId);
    }
    
	/**
     * 根据ID查询标签
     */
    @Override
    public String findTag(Long id){
    	return duibaHdtoolDao.findTag(id);
    }
}
