package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolSkinDataDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolSkinEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolSkinDataService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * ClassName:HdtoolSkinDataServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月1日 下午2:04:14 <br/>
 * @author   zp
 * @version
 * @since    JDK 1.6
 * @see
 */
@Service
public class HdtoolSkinDataServiceImpl implements HdtoolSkinDataService{
    @Resource
    private HdtoolSkinDataDao hdtoolSkinDataDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public void createHdtoolSkinData(HdtoolSkinDto hdtoolSkinDto) {
        if(null == hdtoolSkinDto){
            return;
        }
        HdtoolSkinEntity entity=BeanUtils.copy(hdtoolSkinDto,HdtoolSkinEntity.class);
        hdtoolSkinDataDao.insert(entity);
    }

    @Override
    public int updateHdtoolSkinData(Long hdtoolId,String type,String dataJson) {
        //若存在记录，则去更新数据集
        int ret = hdtoolSkinDataDao.updateDataJson(hdtoolId,type,dataJson);
        if(ret == 1){
            //同时失效缓存
            this.removeHdtoolSkinCache(hdtoolId,type);
        }
        return ret;
    }

    @Override
    public HdtoolSkinDto queryBaseHdtoolSkin(Long hdtoolId, String type) {
        return BeanUtils.copy(hdtoolSkinDataDao.selectByHdtoolIdAndType(hdtoolId, type),HdtoolSkinDto.class);
    }

    @Override
    public String querySkin(Long hdtoolId, String type) {
        String skin = null;//getHdtoolSkin(hdtoolId,type);
        if(StringUtils.isBlank(skin)){
            skin = hdtoolSkinDataDao.selectJsonByHdtoolIdAndType(hdtoolId, type);
            //this.setHdtoolSkinCache(hdtoolId, type, skin);
        }
        return skin;
    }

    /**
     * 删除memcaceh皮肤缓存
     * @author zp
     * @param hdtoolId
     * @param type
     * @since JDK 1.6
     */
    public void removeHdtoolSkinCache(Long hdtoolId,String type) {
        this.memcachedClient.remove(getSkinCacheKey(hdtoolId,type));
    }

    /**
     * 添加memcache皮肤缓存
     * @author zp
     * @param hdtoolId
     * @param type
     * @since JDK 1.6
     */
    public void setHdtoolSkinCache(Long hdtoolId,String type,String json) {
        this.memcachedClient.set(getSkinCacheKey(hdtoolId,type), json, 60 * 60);//缓存时间设置1小时
    }

    /**
     * 从缓存获取里获取模版数据
     * @author zp
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public String getHdtoolSkin(Long hdtoolId,String type){
        return this.memcachedClient.get(getSkinCacheKey(hdtoolId,type));
    }

    /**
     * 获取key
     * @param hdtoolId
     * @return
     */
    public String getSkinCacheKey(Long hdtoolId,String type){
       return CacheConstants.KEY_HDTOOL_SKIN_CACHE_KEY+hdtoolId+"_"+type;
    }

}
