package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDefaultDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolDefaultSkinDataDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolSkinDefaultEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolSkinDefaultDataSerivce;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * ClassName:HdtoolSkinDefaultDataServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月1日 下午6:21:56 <br/>
 * @author   zp
 * @version
 * @since    JDK 1.6
 * @see
 */
@Service
public class HdtoolSkinDefaultDataServiceImpl implements HdtoolSkinDefaultDataSerivce {

    @Resource
    private HdtoolDefaultSkinDataDao hdtoolDefaultSkinDataDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public void createHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) {
        if(null == hdtoolSkinDefaultDto){
            return;
        }
        HdtoolSkinDefaultEntity entity=BeanUtils.copy(hdtoolSkinDefaultDto,HdtoolSkinDefaultEntity.class);
        hdtoolDefaultSkinDataDao.insert(entity);
        hdtoolSkinDefaultDto.setId(entity.getId());
    }

    @Override
    public int updateHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) {
        int ret = hdtoolDefaultSkinDataDao.updateData(BeanUtils.copy(hdtoolSkinDefaultDto,HdtoolSkinDefaultEntity.class));
        if(ret == 1){
            this.removeHdtoolSkinCache(hdtoolSkinDefaultDto.getTemplateType(), hdtoolSkinDefaultDto.getType());
        }
        return ret;
    }

    @Override
    public HdtoolSkinDefaultDto queryHdtoolBaseSkin(String templateType, String type) {
        return BeanUtils.copy(hdtoolDefaultSkinDataDao.selectBaseHdtoolData(templateType, type),HdtoolSkinDefaultDto.class);
    }

    @Override
    public HdtoolSkinDefaultDto queryHdtoolDefaultConfig(String templateType, String type) {
        String defaultConfig = null;//this.getHdtoolDefaultSkin(templateType, type);
        if(StringUtils.isBlank(defaultConfig)){
            HdtoolSkinDefaultDto skin = BeanUtils.copy(hdtoolDefaultSkinDataDao.selectConfigAndStyleData(templateType, type),HdtoolSkinDefaultDto.class);
            if(null != skin){
                //this.setHdtoolSkinCache(templateType, type, skin.getDataConfig(), skin.getDataStyle());
                return skin;
            }
        }else{
            String ct[] = StringUtils.split(defaultConfig,"@");
            if(ct.length == 2){
                HdtoolSkinDefaultDto skin = new HdtoolSkinDefaultDto();
                skin.setTemplateType(templateType);
                skin.setType(type);
                skin.setDataConfig(ct[0]);
                skin.setDataStyle(ct[1]);
                return skin;
            }
        }
        return null;
    }

    /**
     * 删除memcaceh皮肤缓存
     * @author zp
     * @param templateType
     * @param type
     * @since JDK 1.6
     */
    public void removeHdtoolSkinCache(String templateType,String type) {
        this.memcachedClient.remove(getSkinCacheKey(templateType,type));
    }

    /**
     * 添加memcache皮肤缓存
     * @author zp
     * @param templateType
     * @param type
     * @since JDK 1.6
     */
    public void setHdtoolSkinCache(String templateType,String type,String dataConfig,String dataStyle) {
        this.memcachedClient.set(getSkinCacheKey(templateType,type), dataConfig + "@" + dataStyle, 60 * 60);//缓存时间设置1小时
    }

    /**
     * 从缓存获取里获取模版数据
     * @author zp
     * @param templateType
     * @param type
     * @return
     * @since JDK 1.6
     */
    public String getHdtoolDefaultSkin(String templateType,String type){
        return this.memcachedClient.get(getSkinCacheKey(templateType,type));
    }

    /**
     * 获取key
     * @param templateType
     * @return
     */
    public String getSkinCacheKey(String templateType,String type){
        return CacheConstants.KEY_HDTOOL_DEFAULT_SKIN_CACHE_KEY+templateType+"_"+type;
    }

    @Override
    public List<HdtoolSkinDefaultDto> queryListPagnation(Integer offset, Integer max) {
        return BeanUtils.copyList(hdtoolDefaultSkinDataDao.selectAllByPagination(offset, max),HdtoolSkinDefaultDto.class);
    }

    @Override
    public Integer queryListCount() {
        return hdtoolDefaultSkinDataDao.selectAllByPaginationCount();
    }
}


