package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameBrickDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameBrickDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameBrickEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameBrickService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class DuibaNgameBrickServiceImpl implements DuibaNgameBrickService {
    @Resource
    private DuibaNgameBrickDao duibaNgameBrickDao;

    @Override
    public DuibaNgameBrickDto find(Long id) {
        return BeanUtils.copy(duibaNgameBrickDao.find(id), DuibaNgameBrickDto.class);
    }

    @Override
    public void insert(DuibaNgameBrickDto duibaNgameBrickDto) {
        DuibaNgameBrickEntity e = BeanUtils.copy(duibaNgameBrickDto, DuibaNgameBrickEntity.class);
        duibaNgameBrickDao.insert(e);
        duibaNgameBrickDto.setId(e.getId());
    }

    @Override
    public void update4Admin(DuibaNgameBrickDto duibaNgameBrickDto) {
        duibaNgameBrickDao.update4Admin(BeanUtils.copy(duibaNgameBrickDto, DuibaNgameBrickEntity.class));
    }

    @Override
    public DuibaNgameBrickDto findByTitle(String title) {
        return BeanUtils.copy(duibaNgameBrickDao.findByTitle(title), DuibaNgameBrickDto.class);
    }

    @Override
    public void open(Long id) {
        duibaNgameBrickDao.open(id);
    }

    @Override
    public void disable(Long id) {
        duibaNgameBrickDao.disable(id);
    }

    @Override
    public List<DuibaNgameBrickDto> findPage(Integer offset, Integer max) {
        return BeanUtils.copyList(duibaNgameBrickDao.findPage(offset, max), DuibaNgameBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return duibaNgameBrickDao.findPageCount();
    }

    @Override
    public List<DuibaNgameBrickDto> findAll() {
        return BeanUtils.copyList(duibaNgameBrickDao.findAll(), DuibaNgameBrickDto.class);
    }

    @Override
    public String getBrickContentById(Long id) {
        return duibaNgameBrickDao.getBrickContentById(id);
    }

    @Override
    public DuibaNgameBrickDto findNoContent(Long id) {
        return BeanUtils.copy(duibaNgameBrickDao.findNoContent(id), DuibaNgameBrickDto.class);
    }
}
