package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/13.
 */
@Service
public class DuibaNgameServiceImpl implements DuibaNgameService {
    @Resource
    private DuibaNgameDao duibaNgameDao;

    public void update(DuibaNgameDto duibaNgameDO) {
        DuibaNgameEntity e = BeanUtils.copy(duibaNgameDO, DuibaNgameEntity.class);
        duibaNgameDao.update(e);
    }

    public void add(DuibaNgameDto duibaNgameDO) {
        DuibaNgameEntity e = BeanUtils.copy(duibaNgameDO, DuibaNgameEntity.class);
        duibaNgameDao.add(e);
        duibaNgameDO.setId(e.getId());
    }

    public void updateSwitch(DuibaNgameDto duibaNgameDO) {
        DuibaNgameEntity e = BeanUtils.copy(duibaNgameDO, DuibaNgameEntity.class);
        duibaNgameDao.updateSwitch(e);
    }

    @Override
    public List<DuibaNgameDto> findByPage(Integer offset, Integer max, String title, Integer id) {
        List<DuibaNgameEntity> list = duibaNgameDao.findByPage(offset, max, title, id);
        return BeanUtils.copyList(list, DuibaNgameDto.class);
    }

    @Override
    public Long findByPageCount(String title, Integer id) {
        return duibaNgameDao.findByPageCount(title, id);
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_NGAME)
    public DuibaNgameDto findOpenPrizeForUpdate(Long id) {
        return BeanUtils.copy(duibaNgameDao.findOpenPrizeForUpdate(id), DuibaNgameDto.class);
    }

    @Override
    public int count() {
        return duibaNgameDao.count();
    }

    @Override
    public DuibaNgameDto find(Long id) {
        return BeanUtils.copy(duibaNgameDao.find(id), DuibaNgameDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaNgameDao.delete(id);
    }

    @Override
    public List<DuibaNgameDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaNgameDao.findAllByIds(ids), DuibaNgameDto.class);
    }

    @Override
    public List<AddActivityDto> findAllNgame(Long appId) {
        return BeanUtils.copyList(duibaNgameDao.findAllNgame(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaNgameDto> findListByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaNgameDao.findListByIds(ids), DuibaNgameDto.class);
    }

    @Override
    public int updateOpenPrize(Long id) {
        return duibaNgameDao.updateOpenPrize(id);
    }

    @Override
    public List<DuibaNgameDto> findAutoOff() {
        return BeanUtils.copyList(duibaNgameDao.findAutoOff(), DuibaNgameDto.class);
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        return duibaNgameDao.updateStatus(id, status);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return BeanUtils.copy(duibaNgameDao.findExtraInfoById(id), ActivityExtraInfoDto.class);
    }
    
    @Override
    public int updateActivityCategoryId(long id,Long activityCategoryId){
    	return duibaNgameDao.updateActivityCategoryId(id, activityCategoryId);
    }


}
