package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersExtendDto;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameOrdersExtendDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersExtendEntity;
import cn.com.duiba.activity.center.biz.service.ngame.NgameOrdersExtendService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class NgameOrdersExtendServiceImpl implements NgameOrdersExtendService {
    @Resource
    private NgameOrdersExtendDao ngameOrdersExtendDao;

    @Override
    public NgameOrdersExtendDto find(Long id) {
        return BeanUtils.copy(ngameOrdersExtendDao.find(id), NgameOrdersExtendDto.class);
    }

    @Override
    public void insert(NgameOrdersExtendDto ngameOrdersExtendDto) {
        NgameOrdersExtendEntity e = BeanUtils.copy(ngameOrdersExtendDto, NgameOrdersExtendEntity.class);
        ngameOrdersExtendDao.insert(e);
        ngameOrdersExtendDto.setId(e.getId());
    }

    @Override
    public int updateGameData(Long id, String gameData) {
        return ngameOrdersExtendDao.updateGameData(id, gameData);
    }

    @Override
    public String findGameData(Long gameOrdersId) {
        return ngameOrdersExtendDao.findGameData(gameOrdersId);
    }
}
