package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzOptionsDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzOptionsEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzOptionsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * Created by xuezhaoming on 16/6/7.
 */
@Service
public class DuibaQuizzOptionsServiceImpl implements DuibaQuizzOptionsService {

    @Resource
    private DuibaQuizzOptionsDao duibaQuizzOptionsDao;

    @Override
    public List<DuibaQuizzOptionsDto> findOptionsByQuizzId(Long duibaQuizzId) {
        if (duibaQuizzId == null) {
            return Collections.emptyList();
        }

        List<DuibaQuizzOptionsEntity> entities = duibaQuizzOptionsDao.findOptionsByQuizzId(duibaQuizzId);
        return BeanUtils.copyList(entities, DuibaQuizzOptionsDto.class);
    }

    @Override
    public DuibaQuizzOptionsDto find(Long id) {
        if (id == null) {
            return null;
        }

        DuibaQuizzOptionsEntity entity = duibaQuizzOptionsDao.find(id);
        return BeanUtils.copy(entity, DuibaQuizzOptionsDto.class);
    }

    @Override
    public List<DuibaQuizzOptionsDto> findByQuizzId(Long quizzId) {
        return BeanUtils.copyList(duibaQuizzOptionsDao.findOptionsByQuizzId(quizzId), DuibaQuizzOptionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        return duibaQuizzOptionsDao.delete(ids);
    }

    @Override
    public void insert(DuibaQuizzOptionsDto duibaQuizzOptionsDto) {
    	DuibaQuizzOptionsEntity entity = BeanUtils.copy(duibaQuizzOptionsDto, DuibaQuizzOptionsEntity.class);
        duibaQuizzOptionsDao.insert(entity);
        duibaQuizzOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO) {
        return duibaQuizzOptionsDao.updateInfoForm(BeanUtils.copy(quizzOptionsDO, DuibaQuizzOptionsEntity.class));
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return duibaQuizzOptionsDao.updateRemainingById(id, remaining);
    }

}
