package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzAppOrderDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzAppOrderService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.
 */
@Service
public class QuizzAppOrderServiceImpl implements QuizzAppOrderService {

    @Resource
    private QuizzAppOrderDao quizzAppOrderDao;

    @Override
    public List<QuizzOrdersDto> findQuizzOrderLimit50(Long appId, Long activityId) {

        Preconditions.checkNotNull(appId, "appId is null ");
        Preconditions.checkNotNull(activityId, "activityId is null ");

        return BeanUtils.copyList(quizzAppOrderDao.findQuizzOrderLimit50(appId, activityId), QuizzOrdersDto.class);
    }

	@Override
	public List<QuizzOrdersDto> findByLimit(Map<String, Object> map) {
		return BeanUtils.copyList(quizzAppOrderDao.findByLimit(map), QuizzOrdersDto.class);
	}

	@Override
	public Long totalCount(Map<String, Object> map) {
		return quizzAppOrderDao.totalCount(map);
	}

	@Override
	public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(
			List<Long> ids, Long appId) {
		return BeanUtils.copyList(quizzAppOrderDao.countFailByOperatingActivityIds(ids, appId), DeveloperActivityStatisticsDto.class);
	}
	
	@Override
	public Integer insert(QuizzOrdersDto quizzOrdersDto, long id){
		QuizzOrdersEntity entity = BeanUtils.copy(quizzOrdersDto, QuizzOrdersEntity.class);
		quizzOrdersDto.setId(id);
		return quizzAppOrderDao.insert(entity, id);
	}
}
