/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteDuibaQuizzOptionsService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzOptionsService;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzStockService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RemoteDuibaQuizzOptionsServiceImpl
implements RemoteDuibaQuizzOptionsService {
    @Resource
    private DuibaQuizzOptionsService quizzOptionsService;
    @Resource
    private QuizzStockService quizzStockService;

    public List<DuibaQuizzOptionsDto> findOptionsByQuizzId(Long duibaQuizzId) {
        return this.quizzOptionsService.findOptionsByQuizzId(duibaQuizzId);
    }

    public DuibaQuizzOptionsDto find(Long id) {
        return this.quizzOptionsService.find(id);
    }

    public List<DuibaQuizzOptionsDto> findByQuizzId(Long quizzId) {
        List<DuibaQuizzOptionsDto> optionList = this.quizzOptionsService.findByQuizzId(quizzId);
        ArrayList<Long> optionIds = new ArrayList<Long>();
        for (int i = 0; i < optionList.size(); ++i) {
            optionIds.add(optionList.get(i).getId());
        }
        if (!optionIds.isEmpty()) {
            int i;
            List<DuibaQuizzStockDto> stocks = this.quizzStockService.findByQuizzOptionIds(optionIds);
            HashMap<Long, DuibaQuizzStockDto> stockMap = new HashMap<Long, DuibaQuizzStockDto>();
            for (i = 0; i < stocks.size(); ++i) {
                stockMap.put(stocks.get(i).getQuizzOptionId(), stocks.get(i));
            }
            for (i = 0; i < optionList.size(); ++i) {
                DuibaQuizzOptionsDto optionDo = optionList.get(i);
                DuibaQuizzStockDto duibaQuizzStockDO = (DuibaQuizzStockDto)stockMap.get(optionDo.getId());
                if (null == duibaQuizzStockDO) continue;
                optionDo.setOptionCount(duibaQuizzStockDO.getStock());
            }
        }
        return optionList;
    }

    public int delete(List<Long> ids) {
        return this.quizzOptionsService.delete(ids);
    }

    public DuibaQuizzOptionsDto insert(DuibaQuizzOptionsDto quizzOptionsDO) {
        this.quizzOptionsService.insert(quizzOptionsDO);
        return quizzOptionsDO;
    }

    public int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO) {
        return this.quizzOptionsService.updateInfoForm(quizzOptionsDO);
    }

    public int updateRemainingById(Long id, Integer remaining) {
        return this.quizzOptionsService.updateRemainingById(id, remaining);
    }
}

