/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityOptionsDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityOptionsEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OperatingActivityOptionsServiceImpl
implements OperatingActivityOptionsService {
    @Resource
    private OperatingActivityOptionsDao operatingActivityOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-keyOperatingActivityOptionsById_" + id;
    }

    @Override
    public OperatingActivityOptionsDto findOptionById(final Long id) {
        return (OperatingActivityOptionsDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 5, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<OperatingActivityOptionsDto>(){

            public OperatingActivityOptionsDto load() {
                return (OperatingActivityOptionsDto)BeanUtils.copy((Object)((Object)OperatingActivityOptionsServiceImpl.this.operatingActivityOptionsDao.findOptionById(id)), OperatingActivityOptionsDto.class);
            }
        });
    }

    @Override
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(Long operatingActivityId) {
        List<OperatingActivityOptionsEntity> entities = this.operatingActivityOptionsDao.findByOperatingActivityId(operatingActivityId);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        ArrayList<OperatingActivityOptionsDto> dtoList = new ArrayList<OperatingActivityOptionsDto>(entities.size());
        for (OperatingActivityOptionsEntity entity : entities) {
            dtoList.add(this.copyEntity(entity));
        }
        return dtoList;
    }

    @Override
    public Integer countByOperatingActivityId(Long operatingActivityId) {
        return this.operatingActivityOptionsDao.countByOperatingActivityId(operatingActivityId);
    }

    @Override
    public int decrementOptionRemaining(Long optionId) {
        int result = this.operatingActivityOptionsDao.decrementOptionRemaining(optionId);
        this.cacheClient.remove(this.getCacheKeyById(optionId));
        return result;
    }

    @Override
    public int incrementOptionRemaining(Long optionId) {
        int result = this.operatingActivityOptionsDao.incrementOptionRemaining(optionId);
        this.cacheClient.remove(this.getCacheKeyById(optionId));
        return result;
    }

    @Override
    public int updateOptionDeleteStatus(List<Long> oaoList) {
        int result = this.operatingActivityOptionsDao.updateOptionDeleteStatus(oaoList);
        for (Long id : oaoList) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull((Object)operatingActivityOptionsDto);
        int result = this.operatingActivityOptionsDao.updatePrize(this.copyDto(operatingActivityOptionsDto));
        this.cacheClient.remove(this.getCacheKeyById(operatingActivityOptionsDto.getId()));
        return result;
    }

    @Override
    public void insertOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull((Object)operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity = new OperatingActivityOptionsEntity(true);
        BeanUtils.copy((Object)operatingActivityOptionsDto, (Object)((Object)entity));
        this.operatingActivityOptionsDao.insertOption(entity);
        operatingActivityOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull((Object)operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity = new OperatingActivityOptionsEntity(operatingActivityOptionsDto.getId());
        BeanUtils.copy((Object)operatingActivityOptionsDto, (Object)((Object)entity));
        int result = this.operatingActivityOptionsDao.updateOption(entity);
        this.cacheClient.remove(this.getCacheKeyById(operatingActivityOptionsDto.getId()));
        return result;
    }

    @Override
    @Transactional(value="credits")
    public OperatingActivityOptionsDto findForupdate(Long id) {
        OperatingActivityOptionsEntity entity = this.operatingActivityOptionsDao.findForupdate(id);
        return this.copyEntity(entity);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int result = this.operatingActivityOptionsDao.addRemainingById(id, addRemaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int result = this.operatingActivityOptionsDao.subRemainingById(id, subRemaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int result = this.operatingActivityOptionsDao.updateRemainingById(id, remaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    @Transactional(value="credits")
    public Integer findRemaingForupdate(Long id) {
        return this.operatingActivityOptionsDao.findRemaingForupdate(id);
    }

    private OperatingActivityOptionsDto copyEntity(OperatingActivityOptionsEntity entity) {
        if (entity == null) {
            return null;
        }
        OperatingActivityOptionsDto dto = new OperatingActivityOptionsDto();
        BeanUtils.copy((Object)((Object)entity), (Object)dto);
        return dto;
    }

    private OperatingActivityOptionsEntity copyDto(OperatingActivityOptionsDto dto) {
        if (dto == null) {
            return null;
        }
        OperatingActivityOptionsEntity entity = new OperatingActivityOptionsEntity();
        BeanUtils.copy((Object)dto, (Object)((Object)entity));
        return entity;
    }
}

