/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerAppSpecifyService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuestionAnswerAppSpecifyServiceImpl
implements DuibaQuestionAnswerAppSpecifyService {
    @Resource
    private DuibaQuestionAnswerAppSpecifyDao duibaQuestionAnswerAppSpecifyDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKey(Long questionId, Long appId) {
        return "activity-questionAnswerAppSpeByQidAid_" + questionId + "_" + appId;
    }

    @Override
    public DuibaQuestionAnswerAppSpecifyDto findByQuestionAnswerIdAndAppId(final Long questionId, final Long appId) {
        String key = this.getCacheKey(questionId, appId);
        return (DuibaQuestionAnswerAppSpecifyDto)this.cacheClient.getWithCacheLoader(key, 30, TimeUnit.MINUTES, true, (CacheLoader)new CacheLoader<DuibaQuestionAnswerAppSpecifyDto>(){

            public DuibaQuestionAnswerAppSpecifyDto load() {
                return (DuibaQuestionAnswerAppSpecifyDto)BeanUtils.copy((Object)DuibaQuestionAnswerAppSpecifyServiceImpl.this.duibaQuestionAnswerAppSpecifyDao.findByQuestionAnswerIdAndAppId(questionId, appId), DuibaQuestionAnswerAppSpecifyDto.class);
            }
        });
    }

    @Override
    public List<DuibaQuestionAnswerAppSpecifyDto> findByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return BeanUtils.copyList(this.duibaQuestionAnswerAppSpecifyDao.findByDuibaQuestionAnswerId(duibaQuestionAnswerId), DuibaQuestionAnswerAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        DuibaQuestionAnswerAppSpecifyEntity dto = this.duibaQuestionAnswerAppSpecifyDao.find(id);
        if (dto != null) {
            this.duibaQuestionAnswerAppSpecifyDao.delete(id);
            this.cacheClient.remove(this.getCacheKey(dto.getDuibaQuestionAnswerId(), dto.getAppId()));
        }
    }

    @Override
    public void insert(DuibaQuestionAnswerAppSpecifyDto duibaQuestionAnswerAppSpecify) {
        DuibaQuestionAnswerAppSpecifyEntity e = (DuibaQuestionAnswerAppSpecifyEntity)BeanUtils.copy((Object)duibaQuestionAnswerAppSpecify, DuibaQuestionAnswerAppSpecifyEntity.class);
        this.duibaQuestionAnswerAppSpecifyDao.insert(e);
        duibaQuestionAnswerAppSpecify.setId(e.getId());
        this.cacheClient.remove(this.getCacheKey(duibaQuestionAnswerAppSpecify.getDuibaQuestionAnswerId(), duibaQuestionAnswerAppSpecify.getAppId()));
    }

    @Override
    public DuibaQuestionAnswerAppSpecifyDto find(Long id) {
        return (DuibaQuestionAnswerAppSpecifyDto)BeanUtils.copy((Object)this.duibaQuestionAnswerAppSpecifyDao.find(id), DuibaQuestionAnswerAppSpecifyDto.class);
    }
}

