/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOptionsDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOptionsEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOptionsService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuestionAnswerOptionsServiceImpl
implements DuibaQuestionAnswerOptionsService {
    @Resource
    private DuibaQuestionAnswerOptionsDao duibaQuestionAnswerOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyByQuestionId(Long duibaQuestionId) {
        return "activity-duibaQuestionAnswerOptionsByQid_" + duibaQuestionId;
    }

    private String getCacheKeyById(Long id) {
        return "activity-duibaQuestionAnswerOptionsById_" + id;
    }

    @Override
    public List<DuibaQuestionAnswerOptionsDto> findOptionsByQuestionId(Long duibaQuestionId) {
        String key = this.getCacheKeyByQuestionId(duibaQuestionId);
        List list = (List)this.cacheClient.get(key);
        if (list == null) {
            list = BeanUtils.copyList(this.duibaQuestionAnswerOptionsDao.findOptionsByQuestionId(duibaQuestionId), DuibaQuestionAnswerOptionsDto.class);
            this.cacheClient.set(key, (Object)list, 1, TimeUnit.HOURS);
        }
        return list;
    }

    @Override
    public DuibaQuestionAnswerOptionsDto find(Long id) {
        String key = this.getCacheKeyById(id);
        DuibaQuestionAnswerOptionsDto dto = (DuibaQuestionAnswerOptionsDto)this.cacheClient.get(key);
        if (dto == null) {
            dto = (DuibaQuestionAnswerOptionsDto)BeanUtils.copy((Object)this.duibaQuestionAnswerOptionsDao.find(id), DuibaQuestionAnswerOptionsDto.class);
            this.cacheClient.set(key, (Object)dto, 1, TimeUnit.HOURS);
        }
        return dto;
    }

    @Override
    public DuibaQuestionAnswerOptionsDto findById(Long id) {
        return (DuibaQuestionAnswerOptionsDto)BeanUtils.copy((Object)this.duibaQuestionAnswerOptionsDao.findById(id), DuibaQuestionAnswerOptionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        List<DuibaQuestionAnswerOptionsEntity> list = this.duibaQuestionAnswerOptionsDao.findByIds(ids);
        int ret = this.duibaQuestionAnswerOptionsDao.delete(ids);
        if (ret > 0) {
            for (DuibaQuestionAnswerOptionsEntity e : list) {
                this.cacheClient.remove(this.getCacheKeyByQuestionId(e.getDuibaQuestionAnswerId()));
            }
            for (Long id : ids) {
                this.cacheClient.remove(this.getCacheKeyById(id));
            }
        }
        return ret;
    }

    @Override
    public void insert(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        DuibaQuestionAnswerOptionsEntity e = (DuibaQuestionAnswerOptionsEntity)BeanUtils.copy((Object)questionAnswerOptionsDO, DuibaQuestionAnswerOptionsEntity.class);
        this.duibaQuestionAnswerOptionsDao.insert(e);
        questionAnswerOptionsDO.setId(e.getId());
        this.cacheClient.remove(this.getCacheKeyByQuestionId(e.getDuibaQuestionAnswerId()));
    }

    @Override
    public int update(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        DuibaQuestionAnswerOptionsEntity e = this.duibaQuestionAnswerOptionsDao.find(questionAnswerOptionsDO.getId());
        int ret = this.duibaQuestionAnswerOptionsDao.update((DuibaQuestionAnswerOptionsEntity)BeanUtils.copy((Object)questionAnswerOptionsDO, DuibaQuestionAnswerOptionsEntity.class));
        this.cacheClient.remove(this.getCacheKeyByQuestionId(e.getDuibaQuestionAnswerId()));
        this.cacheClient.remove(this.getCacheKeyById(e.getId()));
        return ret;
    }
}

