/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuestionAnswerServiceImpl
implements DuibaQuestionAnswerService {
    @Resource
    private DuibaQuestionAnswerDao duibaQuestionAnswerDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-duibaQuestionAnswerById_" + id;
    }

    @Override
    public DuibaQuestionAnswerDto find(Long id) {
        String key = this.getCacheKeyById(id);
        DuibaQuestionAnswerDto dto = (DuibaQuestionAnswerDto)this.cacheClient.get(key);
        if (dto == null) {
            dto = (DuibaQuestionAnswerDto)BeanUtils.copy((Object)this.duibaQuestionAnswerDao.find(id), DuibaQuestionAnswerDto.class);
            this.cacheClient.set(key, (Object)dto, 1, TimeUnit.HOURS);
        }
        return dto;
    }

    @Override
    public List<DuibaQuestionAnswerDto> findAutoOff() {
        return BeanUtils.copyList(this.duibaQuestionAnswerDao.findAutoOff(), DuibaQuestionAnswerDto.class);
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        int ret = this.duibaQuestionAnswerDao.updateStatus(id, status);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public List<DuibaQuestionAnswerDto> findByIds(List<Long> ids) {
        return BeanUtils.copyList(this.duibaQuestionAnswerDao.findByIds(ids), DuibaQuestionAnswerDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return (ActivityExtraInfoDto)BeanUtils.copy((Object)this.duibaQuestionAnswerDao.findExtraInfoById(id), ActivityExtraInfoDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(this.duibaQuestionAnswerDao.findAllByIds(ids), DuibaQuestionAnswerDto.class);
    }

    @Override
    public List<AddActivityDto> findAllQuestion(Long appId) {
        return BeanUtils.copyList(this.duibaQuestionAnswerDao.findAllQuestion(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findByPage(Integer offset, Integer max) {
        return BeanUtils.copyList(this.duibaQuestionAnswerDao.findByPage(offset, max), DuibaQuestionAnswerDto.class);
    }

    @Override
    public Long findPageCount() {
        return this.duibaQuestionAnswerDao.findPageCount();
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return this.duibaQuestionAnswerDao.findPageCount(paramMap);
    }

    @Override
    public List<DuibaQuestionAnswerDto> findByPage(Map<String, Object> paramMap) {
        return BeanUtils.copyList(this.duibaQuestionAnswerDao.findByPage(paramMap), DuibaQuestionAnswerDto.class);
    }

    @Override
    public int updateStatus(Long id, int status) {
        int ret = this.duibaQuestionAnswerDao.updateStatus(id, status);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int delete(Long id) {
        int ret = this.duibaQuestionAnswerDao.delete(id);
        if (ret > 0) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return ret;
    }

    @Override
    public void insert(DuibaQuestionAnswerDto duibaQuestionAnswerDto) {
        DuibaQuestionAnswerEntity e = (DuibaQuestionAnswerEntity)BeanUtils.copy((Object)duibaQuestionAnswerDto, DuibaQuestionAnswerEntity.class);
        this.duibaQuestionAnswerDao.insert(e);
        duibaQuestionAnswerDto.setId(e.getId());
    }

    @Override
    public int update(DuibaQuestionAnswerDto duibaQuestionAnswerDto) {
        int ret = this.duibaQuestionAnswerDao.update((DuibaQuestionAnswerEntity)BeanUtils.copy((Object)duibaQuestionAnswerDto, DuibaQuestionAnswerEntity.class));
        this.cacheClient.remove(this.getCacheKeyById(duibaQuestionAnswerDto.getId()));
        return ret;
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int ret = this.duibaQuestionAnswerDao.updateAutoOffDateNull(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public void updateSwitches(Long id, Long switches) {
        this.duibaQuestionAnswerDao.updateSwitches(id, switches);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public int updateForEditActivityCategoryId(long id, Long activityCategoryId) {
        int ret = this.duibaQuestionAnswerDao.updateForEditActivityCategoryId(id, activityCategoryId);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }
}

