/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DuibaHdtoolServiceImpl
implements DuibaHdtoolService {
    @Resource
    private DuibaHdtoolDao duibaHdtoolDao;
    @Resource
    private CacheClient cacheClient;

    private String getDuibaHdtoolCacheKeyById(Long id) {
        return "activity-duibaHdtoolById_" + id;
    }

    private String getDuibaHdtoolOptionsCacheKeyById(Long id) {
        return "activity-duibaHdtoolOptionsById_" + id;
    }

    @Override
    public List<DuibaHdtoolDto> findAutoOff() {
        return BeanUtils.copyList(this.duibaHdtoolDao.findAutoOff(), DuibaHdtoolDto.class);
    }

    @Override
    public DuibaHdtoolDto find(final Long id) {
        return (DuibaHdtoolDto)this.cacheClient.getWithCacheLoader(this.getDuibaHdtoolCacheKeyById(id), 5, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<DuibaHdtoolDto>(){

            public DuibaHdtoolDto load() {
                return (DuibaHdtoolDto)BeanUtils.copy((Object)DuibaHdtoolServiceImpl.this.duibaHdtoolDao.find(id), DuibaHdtoolDto.class);
            }
        });
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaHdToolsList(Map<String, Object> paramMap) {
        return BeanUtils.copyList(this.duibaHdtoolDao.findDuibaHdToolsList(paramMap), DuibaHdtoolDto.class);
    }

    @Override
    public Integer countDuibaHdToolsList(Map<String, Object> queryMap) {
        return this.duibaHdtoolDao.countDuibaHdToolsList(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaHdTools(Long appId) {
        return BeanUtils.copyList(this.duibaHdtoolDao.findAllDuibaHdTools(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaHdtoolDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(this.duibaHdtoolDao.findAllByIds(ids), DuibaHdtoolDto.class);
    }

    @Override
    public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId) {
        return BeanUtils.copyList(this.duibaHdtoolDao.findOptionsByDuibaHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public Integer countOptionsByHdtoolId(Long hdtoolId) {
        return this.duibaHdtoolDao.countOptionsByHdtoolId(hdtoolId);
    }

    @Override
    public DuibaHdtoolOptionsDto findOptionById(final Long id) {
        return (DuibaHdtoolOptionsDto)this.cacheClient.getWithCacheLoader(this.getDuibaHdtoolOptionsCacheKeyById(id), 30, TimeUnit.SECONDS, (CacheLoader)new CacheLoader<DuibaHdtoolOptionsDto>(){

            public DuibaHdtoolOptionsDto load() {
                return (DuibaHdtoolOptionsDto)BeanUtils.copy((Object)DuibaHdtoolServiceImpl.this.duibaHdtoolDao.findOptionById(id), DuibaHdtoolOptionsDto.class);
            }
        });
    }

    @Override
    @Transactional(value="credits")
    public DuibaHdtoolOptionsDto findOptionByIdForupdate(Long id) {
        return (DuibaHdtoolOptionsDto)BeanUtils.copy((Object)this.duibaHdtoolDao.findOptionByIdForupdate(id), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public List<HdtoolAppSpecifyDto> findAllSpecifyByHdToolId(Long hdToolId) {
        return BeanUtils.copyList(this.duibaHdtoolDao.findAllSpecifyByHdToolId(hdToolId), HdtoolAppSpecifyDto.class);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId) {
        return (HdtoolAppSpecifyDto)BeanUtils.copy((Object)this.duibaHdtoolDao.findSpecifyByHdToolIdAndApp(duibaHdToolId, appId), HdtoolAppSpecifyDto.class);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyById(Long id) {
        return (HdtoolAppSpecifyDto)BeanUtils.copy((Object)this.duibaHdtoolDao.findSpecifyById(id), HdtoolAppSpecifyDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return (ActivityExtraInfoDto)BeanUtils.copy((Object)this.duibaHdtoolDao.findExtraInfoById(id), ActivityExtraInfoDto.class);
    }

    @Override
    public List<Long> findHasUserdHdIds(Long itemId) {
        return this.duibaHdtoolDao.findHasUserdHdIds(itemId);
    }

    @Override
    public Long getCountDuibaHdTool(Map<String, Object> queryMap) {
        return this.duibaHdtoolDao.getCountDuibaHdTool(queryMap);
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaToolList(Map<String, Object> queryMap) {
        return BeanUtils.copyList(this.duibaHdtoolDao.findDuibaToolList(queryMap), DuibaHdtoolDto.class);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int ret = this.duibaHdtoolDao.updateAutoOffDateNull(id);
        this.cacheClient.remove(this.getDuibaHdtoolCacheKeyById(id));
        return ret;
    }

    @Override
    public void insert(DuibaHdtoolDto duibaHdtoolDto) {
        DuibaHdtoolEntity e = (DuibaHdtoolEntity)BeanUtils.copy((Object)duibaHdtoolDto, DuibaHdtoolEntity.class);
        this.duibaHdtoolDao.insert(e);
        duibaHdtoolDto.setId(e.getId());
    }

    @Override
    public int deleteById(Long id) {
        int ret = this.duibaHdtoolDao.deleteById(id);
        this.cacheClient.remove(this.getDuibaHdtoolCacheKeyById(id));
        return ret;
    }

    @Override
    public int update(DuibaHdtoolDto duibaHdtoolDto) {
        int ret = this.duibaHdtoolDao.update((DuibaHdtoolEntity)BeanUtils.copy((Object)duibaHdtoolDto, DuibaHdtoolEntity.class));
        this.cacheClient.remove(this.getDuibaHdtoolCacheKeyById(duibaHdtoolDto.getId()));
        return ret;
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        int ret = this.duibaHdtoolDao.updateStatus(id, status);
        this.cacheClient.remove(this.getDuibaHdtoolCacheKeyById(id));
        return ret;
    }

    @Override
    public int decrementOptionRemaining(Long id) {
        int ret = this.duibaHdtoolDao.decrementOptionRemaining(id);
        this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyById(id));
        return ret;
    }

    @Override
    public int incrementOptionRemaining(Long id) {
        int ret = this.duibaHdtoolDao.incrementOptionRemaining(id);
        this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyById(id));
        return ret;
    }

    @Override
    public int deleteOptions(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        int ret = this.duibaHdtoolDao.deleteOptions(ids);
        for (Long id : ids) {
            this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyById(id));
        }
        return ret;
    }

    @Override
    public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        int ret = this.duibaHdtoolDao.updateHdtoolPrize((DuibaHdtoolOptionsEntity)BeanUtils.copy((Object)duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
        this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyById(duibaHdToolOptionDO.getId()));
        return ret;
    }

    @Override
    public void insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        DuibaHdtoolOptionsEntity e = (DuibaHdtoolOptionsEntity)BeanUtils.copy((Object)duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class);
        this.duibaHdtoolDao.insertHdtoolOption(e);
        duibaHdToolOptionDO.setId(e.getId());
    }

    @Override
    public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        int ret = this.duibaHdtoolDao.updateHdtoolOption((DuibaHdtoolOptionsEntity)BeanUtils.copy((Object)duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
        this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyById(duibaHdToolOptionDO.getId()));
        return ret;
    }

    @Override
    public int deleteSpecifyById(Long id) {
        return this.duibaHdtoolDao.deleteSpecifyById(id);
    }

    @Override
    public void insertSpecify(HdtoolAppSpecifyDto hdtoolAppSpecifyDO) {
        HdtoolAppSpecifyEntity e = (HdtoolAppSpecifyEntity)BeanUtils.copy((Object)hdtoolAppSpecifyDO, HdtoolAppSpecifyEntity.class);
        this.duibaHdtoolDao.insertSpecify(e);
        hdtoolAppSpecifyDO.setId(e.getId());
    }

    @Override
    public int updateActivityCategory(long duibaHdtoolId, long activityCategoryId) {
        int ret = this.duibaHdtoolDao.updateActivityCategory(duibaHdtoolId, activityCategoryId);
        this.cacheClient.remove(this.getDuibaHdtoolCacheKeyById(duibaHdtoolId));
        return ret;
    }

    @Override
    public String findTag(Long id) {
        return this.duibaHdtoolDao.findTag(id);
    }
}

