/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.manual.impl;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.biz.dao.manuallottery.AppManualLotteryDao;
import cn.com.duiba.activity.center.biz.entity.manual.AppManualLotteryEntity;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.support.copier.manual.AppManualLotteryCopier;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AppManualLotteryServiceImpl
implements AppManualLotteryService {
    @Resource
    private AppManualLotteryDao appManualLotteryDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-appManualLotteryById_" + id;
    }

    @Override
    public List<AppManualLotteryDto> scanOverManualLottery() {
        List<AppManualLotteryEntity> entities = this.appManualLotteryDao.scanOverManualLottery();
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        ArrayList<AppManualLotteryDto> appManualLotteryDtos = new ArrayList<AppManualLotteryDto>(entities.size());
        for (AppManualLotteryEntity appManualLotteryEntity : entities) {
            AppManualLotteryDto appManualLotteryDto = new AppManualLotteryDto();
            AppManualLotteryCopier.Entity2DTO.copy((Object)appManualLotteryEntity, (Object)appManualLotteryDto, null);
            appManualLotteryDtos.add(appManualLotteryDto);
        }
        return appManualLotteryDtos;
    }

    @Override
    public void updateManualLottery(AppManualLotteryDto appManualLottery) {
        Preconditions.checkNotNull((Object)appManualLottery);
        AppManualLotteryEntity appManualLotteryEntity = this.dto2entity(appManualLottery);
        this.appManualLotteryDao.updateManualLottery(appManualLotteryEntity);
        this.cacheClient.remove(this.getCacheKeyById(appManualLottery.getId()));
    }

    private AppManualLotteryEntity dto2entity(AppManualLotteryDto appManualLottery) {
        AppManualLotteryEntity appManualLotteryEntity = AppManualLotteryCopier.dto2Entity(appManualLottery);
        return appManualLotteryEntity;
    }

    @Override
    public void insert(AppManualLotteryDto appManualLotteryDto) {
        Preconditions.checkNotNull((Object)appManualLotteryDto);
        AppManualLotteryEntity appManualLotteryEntity = this.dto2entity(appManualLotteryDto);
        this.appManualLotteryDao.insert(appManualLotteryEntity);
        appManualLotteryDto.setId(appManualLotteryEntity.getId());
    }

    @Override
    public void update(AppManualLotteryDto appManualLotteryDto) {
        Preconditions.checkNotNull((Object)appManualLotteryDto);
        AppManualLotteryEntity appManualLotteryEntity = this.dto2entity(appManualLotteryDto);
        this.appManualLotteryDao.update(appManualLotteryEntity);
        this.cacheClient.remove(this.getCacheKeyById(appManualLotteryDto.getId()));
    }

    @Override
    public AppManualLotteryDto find(Long id) {
        if (id == null) {
            return null;
        }
        String key = this.getCacheKeyById(id);
        AppManualLotteryDto d = (AppManualLotteryDto)this.cacheClient.get(key);
        if (d == null) {
            AppManualLotteryEntity appManualLotteryEntity = this.appManualLotteryDao.find(id);
            if (appManualLotteryEntity == null) {
                return null;
            }
            d = AppManualLotteryCopier.entity2dto(appManualLotteryEntity);
            this.cacheClient.set(key, (Object)d, 1, TimeUnit.HOURS);
        }
        return d;
    }

    @Override
    public List<AppManualLotteryDto> findAllByIds(List<Long> ids) {
        ArrayList<AppManualLotteryDto> list = new ArrayList<AppManualLotteryDto>();
        if (ids != null && ids.size() > 0) {
            for (Long id : ids) {
                AppManualLotteryDto app;
                if (id == null || (app = this.find(id)) == null) continue;
                list.add(app);
            }
        }
        return list;
    }
}

