/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzOptionsDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzOptionsEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzOptionsService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuizzOptionsServiceImpl
implements DuibaQuizzOptionsService {
    @Resource
    private DuibaQuizzOptionsDao duibaQuizzOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-duibaQuizzOptionsById_" + id;
    }

    @Override
    public List<DuibaQuizzOptionsDto> findOptionsByQuizzId(Long duibaQuizzId) {
        if (duibaQuizzId == null) {
            return Collections.emptyList();
        }
        List<DuibaQuizzOptionsEntity> entities = this.duibaQuizzOptionsDao.findOptionsByQuizzId(duibaQuizzId);
        return BeanUtils.copyList(entities, DuibaQuizzOptionsDto.class);
    }

    @Override
    public DuibaQuizzOptionsDto find(final Long id) {
        if (id == null) {
            return null;
        }
        return (DuibaQuizzOptionsDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<DuibaQuizzOptionsDto>(){

            public DuibaQuizzOptionsDto load() {
                DuibaQuizzOptionsEntity entity = DuibaQuizzOptionsServiceImpl.this.duibaQuizzOptionsDao.find(id);
                return (DuibaQuizzOptionsDto)BeanUtils.copy((Object)((Object)entity), DuibaQuizzOptionsDto.class);
            }
        });
    }

    @Override
    public List<DuibaQuizzOptionsDto> findByQuizzId(Long quizzId) {
        return BeanUtils.copyList(this.duibaQuizzOptionsDao.findOptionsByQuizzId(quizzId), DuibaQuizzOptionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        int ret = this.duibaQuizzOptionsDao.delete(ids);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return ret;
    }

    @Override
    public void insert(DuibaQuizzOptionsDto duibaQuizzOptionsDto) {
        DuibaQuizzOptionsEntity entity = (DuibaQuizzOptionsEntity)((Object)BeanUtils.copy((Object)duibaQuizzOptionsDto, DuibaQuizzOptionsEntity.class));
        this.duibaQuizzOptionsDao.insert(entity);
        duibaQuizzOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO) {
        int ret = this.duibaQuizzOptionsDao.updateInfoForm((DuibaQuizzOptionsEntity)((Object)BeanUtils.copy((Object)quizzOptionsDO, DuibaQuizzOptionsEntity.class)));
        this.cacheClient.remove(this.getCacheKeyById(quizzOptionsDO.getId()));
        return ret;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int ret = this.duibaQuizzOptionsDao.updateRemainingById(id, remaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }
}

