/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersDao;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.QuizzMQSend;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrdersStatusChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuizzOrdersStatusChangeServiceImpl
implements QuizzOrdersStatusChangeService {
    @Resource
    private QuizzOrdersStatusChangeDao quizzOrdersStatusChangeDao;
    @Autowired
    private QuizzOrdersDao quizzOrdersDao;
    @Resource
    private QuizzMQSend quizzMQSend;

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        int ret = this.quizzOrdersStatusChangeDao.updateExchangeStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        QuizzOrdersEntity quizzOrdersEntity = this.quizzOrdersDao.find(id);
        int ret = this.quizzOrdersStatusChangeDao.updateExchangeStatusToOverdue(id, quizzOrdersEntity.getConsumerId(), error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(quizzOrdersEntity.getConsumerId(), id);
        }
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        int ret = this.quizzOrdersStatusChangeDao.updateStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        int ret = this.quizzOrdersStatusChangeDao.doTakePrize(consumerId, id);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        int ret = this.quizzOrdersStatusChangeDao.rollbackTakePrize(consumerId, id);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        int ret = this.quizzOrdersStatusChangeDao.updateLotteryResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer updateLotteryLuckResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        Preconditions.checkNotNull((Object)consumerId, (Object)"consumerId is null ");
        Preconditions.checkNotNull((Object)id, (Object)"id is null ");
        int ret = this.quizzOrdersStatusChangeDao.updateLotteryLuckResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
        if (ret == 1) {
            this.quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer insert(QuizzOrdersDto quizzOrdersDto, long id) {
        QuizzOrdersEntity entity = (QuizzOrdersEntity)((Object)BeanUtils.copy((Object)quizzOrdersDto, QuizzOrdersEntity.class));
        int num = this.quizzOrdersStatusChangeDao.insert(entity, id);
        quizzOrdersDto.setId(Long.valueOf(id));
        return num;
    }

    @Override
    public QuizzOrdersDto find(Long consumerId, Long id) {
        QuizzOrdersEntity entity = this.quizzOrdersStatusChangeDao.find(consumerId, id);
        return (QuizzOrdersDto)BeanUtils.copy((Object)((Object)entity), QuizzOrdersDto.class);
    }
}

