/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.biz.dao.guess.GuessOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.kafka.GuessMQSend;
import cn.com.duiba.activity.center.biz.service.guess.GuessOrdersStatusChangeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GuessOrdersStatusChangeServiceImpl
implements GuessOrdersStatusChangeService {
    @Autowired
    private GuessMQSend guessMQSend;
    @Autowired
    private GuessOrdersStatusChangeDao guessOrdersStatusChangeDao;

    @Override
    public int updateStatusToSuccess(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        int ret = this.guessOrdersStatusChangeDao.updateStatusToSuccess(consumerId, guessOrderId, guessOrderExtraId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long guessOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.guessOrdersStatusChangeDao.updateStatusToFail(consumerId, guessOrderId, error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long guessOrderId) {
        int ret = this.guessOrdersStatusChangeDao.updateExchangeStatusToWaitOpen(consumerId, guessOrderId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long guessOrderId, Long guessOrderExtraId) {
        int ret = this.guessOrdersStatusChangeDao.updateExchangeStatusToWaitOpenAndExtraId(consumerId, guessOrderId, guessOrderExtraId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, guessOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = this.guessOrdersStatusChangeDao.updateExchangeStatusToWait(consumerId, gameOrderId, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.guessOrdersStatusChangeDao.updateExchangeStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int doTakePrize(Long consumerId, Long gameOrderId) {
        int ret = this.guessOrdersStatusChangeDao.doTakePrize(consumerId, gameOrderId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long gameOrderId) {
        int ret = this.guessOrdersStatusChangeDao.rollbackTakePrize(consumerId, gameOrderId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = this.guessOrdersStatusChangeDao.updateManualOpenPrizeExchangeStatusToWait(consumerId, gameOrderId, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateIsGivePrize(Long consumerId, Long id, int b) {
        int ret = this.guessOrdersStatusChangeDao.updateIsGivePrize(consumerId, id, b);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = this.guessOrdersStatusChangeDao.updateExchangeStatusToOverdue(consumerId, id, error4admin, error4developer, error4consumer);
        this.guessMQSend.guessSendDataSync(consumerId, id);
        return ret;
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        int ret = this.guessOrdersStatusChangeDao.updateStatusToConsumeSuccess(consumerId, gameOrderId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long guessOrderExtraId) {
        int ret = this.guessOrdersStatusChangeDao.updateExchangeStatusToWaitOpenAndExtraIdForLuck(consumerId, gameOrderId, guessOrderExtraId);
        if (ret == 1) {
            this.guessMQSend.guessSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }
}

