/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolSkinDataDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolSkinEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolSkinDataService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HdtoolSkinDataServiceImpl
implements HdtoolSkinDataService {
    @Resource
    private HdtoolSkinDataDao hdtoolSkinDataDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public void createHdtoolSkinData(HdtoolSkinDto hdtoolSkinDto) {
        if (null == hdtoolSkinDto) {
            return;
        }
        HdtoolSkinEntity entity = (HdtoolSkinEntity)BeanUtils.copy((Object)hdtoolSkinDto, HdtoolSkinEntity.class);
        this.hdtoolSkinDataDao.insert(entity);
        hdtoolSkinDto.setId(entity.getId());
    }

    @Override
    public int updateHdtoolSkinData(Long hdtoolId, String type, String dataJson) {
        int ret = this.hdtoolSkinDataDao.updateDataJson(hdtoolId, type, dataJson);
        if (ret == 1) {
            this.removeHdtoolSkinCache(hdtoolId, type);
        }
        return ret;
    }

    @Override
    public HdtoolSkinDto queryBaseHdtoolSkin(Long hdtoolId, String type) {
        return (HdtoolSkinDto)BeanUtils.copy((Object)this.hdtoolSkinDataDao.selectByHdtoolIdAndType(hdtoolId, type), HdtoolSkinDto.class);
    }

    @Override
    public HdtoolSkinDto queryBaseHdtoolSkinAppId(Long hdtoolId, String type, Long appId) {
        return (HdtoolSkinDto)BeanUtils.copy((Object)this.hdtoolSkinDataDao.selectByHdtoolIdTypeAndAppId(hdtoolId, type, appId), HdtoolSkinDto.class);
    }

    @Override
    public String querySkin(Long hdtoolId, String type) {
        String skin = this.getHdtoolSkin(hdtoolId, type);
        if (StringUtils.isBlank((String)skin)) {
            skin = this.hdtoolSkinDataDao.selectJsonByHdtoolIdAndType(hdtoolId, type);
            this.setHdtoolSkinCache(hdtoolId, type, skin);
        }
        return skin;
    }

    public void removeHdtoolSkinCache(Long hdtoolId, String type) {
        this.memcachedClient.remove(this.getSkinCacheKey(hdtoolId, type));
    }

    public void setHdtoolSkinCache(Long hdtoolId, String type, String json) {
        this.memcachedClient.set(this.getSkinCacheKey(hdtoolId, type), (Object)json, 3600);
    }

    public String getHdtoolSkin(Long hdtoolId, String type) {
        return (String)this.memcachedClient.get(this.getSkinCacheKey(hdtoolId, type));
    }

    public String getSkinCacheKey(Long hdtoolId, String type) {
        return "activity-keyHdtoolSkinCacheKeyId_" + hdtoolId + "_" + type;
    }
}

