/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.impl;

import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activityCategoryService")
public class ActivityCategoryServiceImpl
implements ActivityCategoryService {
    @Autowired
    private ActivityCategoryDao activityCategoryDao;

    @Override
    public Long createCategory(String name) {
        ActivityCategoryEntity e = new ActivityCategoryEntity();
        e.setName(name);
        this.activityCategoryDao.insert(e);
        return e.getId();
    }

    @Override
    public Boolean editCategoryContent(long id, String content) {
        int ret = this.activityCategoryDao.updateCategoryContent(id, content);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean enableCategory(long id) {
        int ret = this.activityCategoryDao.updateCategoryEnable(id);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean disableCategory(long id) {
        int ret = this.activityCategoryDao.updateCategoryDisable(id);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public List<ActivityCategoryEntity> findAll() {
        return this.activityCategoryDao.selectAll();
    }

    @Override
    public ActivityCategoryEntity findDefaultCategory() {
        List<ActivityCategoryEntity> list = this.findAll();
        for (ActivityCategoryEntity e : list) {
            if (!e.getDefaultCategory().booleanValue()) continue;
            return e;
        }
        return null;
    }

    @Override
    public ActivityCategoryEntity findById(long id) {
        return this.activityCategoryDao.select(id);
    }
}

