package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionAnswerOrdersDaoImpl extends ActivityBaseDao implements DuibaQuestionAnswerOrdersDao {

	@Override
	public void insert(DuibaQuestionAnswerOrdersEntity order) {
	    insert("insert", order);
	}

	@Override
	public void updateStatusToConsumeSuccess(Long id) {
         Map<String, Object> parames = new HashMap<String, Object>();
         parames.put("id", id);
		update("updateStatusCreateToConsumeSuccess", parames);
	}
	
    @Override
    public void updateStatusToSuccess(Long id) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", id);
       update("updateStatusToSuccess", parames);
    }

	@Override
	public DuibaQuestionAnswerOrdersEntity find(Long id) {
	    Map<String, Object> parames = new HashMap<String, Object>();
	    parames.put("id", id);
		return selectOne("find", parames);
	}

	@Override
	public void updateStatusToConsumeFail(Long id, String error4admin,String error4developer, String error4consumer) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", id);
        parames.put("error4admin", error4admin);
        parames.put("error4developer", error4developer);
        parames.put("error4consumer", error4consumer);
        update("updateStatusCreateToConsumeFail", parames);
	}

	@Override
	public void updateDeveloperBizId(Long questionOrderId, String bizId) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
        parames.put("developer_biz_id", bizId);
        update("updateDeveloperBizId", parames);
	}

     /**
     * 查询用户参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countByConsumerIdAndOperatingActivityId", paramMap);
    }

    /**
     * 查询用户在时间段内参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("countByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    /**
     * 查询用户免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countFreeByConsumerIdAndOperatingActivityId", paramMap);
    }

    /**
     * 查询用户在时间段内免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

	@Override
	public void updateExchangeStatusToFail(Long questionOrderId, String error4admin,String error4developer, String error4consumer) {
		Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
        parames.put("exchangeStatus", DuibaQuestionAnswerOrdersDto.ExchangeStatusFail);
        parames.put("error4admin", error4admin);
        parames.put("error4developer", error4developer);
        parames.put("error4consumer", error4consumer);
		update("updateExchangeStatusToFail", parames);
	}

	@Override
	public void updateMainOrderId(Long questionOrderId, Long mainOrderId,String mainOrderNum) {
		Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
        parames.put("mainOrderId", mainOrderId);
        parames.put("mainOrderNum", mainOrderNum);
		update("updateMainOrderId", parames);
	}

	@Override
	public int updateExchangeStatusToOverdue(Long questionOrderId,String error4admin, String error4developer, String error4consumer) {
		Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
        parames.put("exchangeStatus", DuibaQuestionAnswerOrdersDto.ExchangeStatusOverdue);
        parames.put("error4admin", error4admin);
        parames.put("error4developer", error4developer);
        parames.put("error4consumer", error4consumer);
		return update("updateExchangeStatusToOverdue", parames);
	}

	@Override
	public int doTakePrize(Long questionOrderId) {
		Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
		return update("doTakePrize", parames);
	}

	@Override
	public void rollbackTakePrize(Long questionOrderId) {
		Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
		update("rollbackTakePrize", parames);
	}

	@Override
	public List<Long> findOverdueOrder() {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("nowTime", new Date());
		return selectList("findOverdueOrder", paramMap);
	}

	@Override
	public List<DuibaQuestionAnswerOrdersEntity> findByIds(List<Long> questionIds) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("list", questionIds);
		return selectList("findByIds", paramMap);
	}

    @Override
    public int updateExchangeStatusToSucess(Long questionOrderId, String error4admin,
                                            String error4developer, String error4consumer) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
        parames.put("exchangeStatus", DuibaQuestionAnswerOrdersDto.ExchangeStatusSuccess);
        return update("updateExchangeStatusToSucess", parames);
    }

    @Override
    public int updateExchangeStatusToWait(Long questionOrderId, String error4admin,
                                          String error4developer, String error4consumer) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", questionOrderId);
        parames.put("exchangeStatus", DuibaQuestionAnswerOrdersDto.ExchangeStatusWait);
        return update("updateExchangeStatusToWait", parames);
    }

    @Override
    public void updatePrizeInfo(DuibaQuestionAnswerOrdersEntity questionOrdersDO) {
        update("updatePrizeInfo", questionOrdersDO);
    }

    @Override
    public void updateScore(Long orderId, Integer rightCount) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", orderId);
        parames.put("score", rightCount);
        update("updateScore", parames);
    }

    @Override
    public DuibaQuestionAnswerOrdersEntity findByAppAndDeveloperBizId(Long appId, String bizId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("bizId", bizId);
        return selectOne("findByAppAndDeveloperBizId", paramMap);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersEntity> findQuestionOrderLimit50(Long appId, Long activityId){
	   Map<String, Object> paramMap = new HashMap<String, Object>();
       paramMap.put("appId", appId);
       paramMap.put("activityId",activityId);
       return selectList("findQuestionOrderLimit50", paramMap);
    }

    @Override
    public int updateLuckPrizeNone(DuibaQuestionAnswerOrdersEntity order){
    	return update("updateLuckPrizeNone", order);
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("countFailByOperatingActivityIds", paramMap);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersEntity> findByLimit(Map<String, Object> queryMap) {
        return selectList("findByLimit", queryMap);
    }

    @Override
    public Long totalCount(Map<String, Object> queryMap) {
        return selectOne("totalCount", queryMap);
    }
    
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
    }
}
