package cn.com.duiba.activity.center.biz.dao.seconds_kill.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityBrickDao;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityBrickEntity;

@Repository
public class DuibaSecondsKillActivityBrickDaoImpl extends ActivityBaseDao implements DuibaSecondsKillActivityBrickDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
    
    @Override
	public List<DuibaSecondsKillActivityBrickEntity> findPage(Map<String, Object> paramMap) {
		return selectList("findPage", paramMap);
	}

	@Override
	public Long findPageCount() {
		return selectOne("findPageCount");
	}

	@Override
	public DuibaSecondsKillActivityBrickEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public void insert(DuibaSecondsKillActivityBrickEntity duibaSecondsKillActivityBrick) {
		insert("insert", duibaSecondsKillActivityBrick);
	}

	@Override
	public void update(DuibaSecondsKillActivityBrickEntity duibaSecondsKillActivityBrick) {
		update("update", duibaSecondsKillActivityBrick);
	}

	@Override
	public void open(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("open", paramMap);
	}

	@Override
	public void disable(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		update("disable", paramMap);
	}

	@Override
	public DuibaSecondsKillActivityBrickEntity findByTitle(String title) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("title", title);
		return selectOne("findByTitle", paramMap);
	}

	@Override
	public List<DuibaSecondsKillActivityBrickEntity> findAllEnable() {
		return selectList("findAllEnable");
	}
}
