package cn.com.duiba.activity.center.biz.kafka;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
	private static final Logger log = LoggerFactory.getLogger(MessageService.class);

	@Autowired
	private KafkaClient kafkaClient;

	/**
	 * 发送MQ消息,如果出错会自动重试最多三次
	 * @param queueName
	 * @param message
	 * @return
	 * @throws Exception
     */
	public String sendMsg(String queueName, Message message) throws Exception {
		String json = JSONObject.toJSONString(message);
		if(json.length() > message.getMaxBodyBytes()){
			log.error("queueName:"+queueName+",json:["+json+"] is too long,current:"+json.length()+",max:"+message.getMaxBodyBytes()+",will not send");
		}
		Exception ex = null;
		for (int i = 0; i < 3; i++) {
			try {
				String msgId = kafkaClient.sendMsg(queueName, json);
				return msgId;
			} catch (Exception e) {
				ex = e;
			}
		}

		throw ex;
	}

}
