package cn.com.duiba.activity.center.biz.remoteservice.impl.singlelottery;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.api.remoteservice.singlelottery.RemoteSingleLotteryServiceNew;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/6/20.
 */
@Service
public class RemoteSingleLotteryServiceNewImpl implements RemoteSingleLotteryServiceNew {
    @Resource
    private SingleLotteryService singleLotteryService;

    @Override
    public AppSingleLotteryDto find(Long id) {
        return singleLotteryService.find(id);
    }

    @Override
    public List<AppSingleLotteryDto> findAllByIds(List<Long> ids) {
        return singleLotteryService.findAllByIds(ids);
    }

    @Override
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining) {
        return singleLotteryService.addMainAppItemRemainingById(id, addMainAppItemRemaining);
    }

    @Override
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining) {
        return singleLotteryService.subMainAppItemRemainingById(id, subMainAppItemRemaining);
    }

    @Override
    public AppSingleLotteryDto insert(AppSingleLotteryDto appSingleLotteryDO) {
        singleLotteryService.insert(appSingleLotteryDO);
        return appSingleLotteryDO;
    }

    @Override
    public int update(AppSingleLotteryDto appSingleLotteryDO) {
        return singleLotteryService.update(appSingleLotteryDO);
    }

    @Override
    public int reduceMainAppItemRemaining(Long id) {
        return singleLotteryService.reduceMainAppItemRemaining(id);
    }

    @Override
    public int addMainAppItemRemaining(Long id) {
        return singleLotteryService.addMainAppItemRemaining(id);
    }

    @Override
    public int updateForDevEdit(AppSingleLotteryDto appSingleLottery) {
        return singleLotteryService.updateForDevEdit(appSingleLottery);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        return singleLotteryService.findRemaingForupdate(id);
    }

    @Override
    public AppSingleLotteryDto findForupdate(Long id) {
        return BeanUtils.copy(singleLotteryService.findForupdate(id),AppSingleLotteryDto.class);
    }
}
