package cn.com.duiba.activity.center.biz.dao.category;

import java.util.List;

import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
/**
 * 活动子页面定向
 * Author ：zhengjy <br/>
 * Create Time：2016年9月9日 下午7:25:21 <br/>
 */
public interface ActivityCategorySpecifyDao {
	
	/**
	 * 活动子页面-查询活动定向开发者列表
	 * @param activityCategoryId 
	 * @return 
	 */
	List<ActivityCategorySpecifyEntity> selectSpecifyAll(Long activityCategoryId, Integer pageIndex, Integer pageSize);
	/**
	 * 活动子页面-查询活动定向开发者count
	 * @author zhengjy
	 * @param activityCategoryId 
	 * @return
	 */
	public Integer selectSpecifyAllCount(Long activityCategoryId,Integer pageIndex,Integer pageSize);
	
	/**
	 * 活动子页面-保存开发者定向
	 * @author zhengjy
	 * @param activityCategorySpecifyEntity
	 * @return
	 */
	public Integer insertSpecify(ActivityCategorySpecifyEntity activityCategorySpecifyEntity);
	
	/**
	 * 活动子页面-删除开发者定向
	 * @author zhengjy
	 * @param id
	 * @return
	 */
	public Integer deleteSpecify(Long id);
	
	/**
	 * 活动子页面-查询app下定向活动列表
	 * @author zhengjy
	 * @param Long appId 
	 * @return 
	 */
	public List<ActivityCategorySpecifyEntity> selectByAppSpecifys(Long appId);
	/**
	 * 查询定向
	 * @author zhengjy
	 * @param id
	 * @return
	 */
	public ActivityCategorySpecifyEntity selectById(Long id);
	/**
	 * 根据子页面id查询定向appId白名单
	 *
	 * @author zhanglihui
	 * @param activityCategoryId
	 * @return
	 * @since JDK 1.6
	 */
    public List<Long> findAppIdList(Long activityCategoryId);
	
}
