package cn.com.duiba.activity.center.biz.dao.gamecommon.impl;

import java.util.Map;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.gamecommon.CustomerGameAppDao;
import cn.com.duiba.activity.center.biz.entity.common.CustomerGameAppEntity;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;



/**
 * describe : 小游戏dao实现类
 * @author  : cdm
 * @date    : 2016年10月13日 下午5:45:05
 */
@Repository
public class CustomerGameAppDaoImpl extends ActivityBaseDao implements CustomerGameAppDao {
	
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
        
    }

	@Override
	public CustomerGameAppEntity selectOneById(Long id) {
		return selectOne("selectOneById",id);
	}

	@Override
	public Long insert(CustomerGameAppEntity entity) {
		 insert("insert", entity);
         return entity.getId();
	}

	@Override
	public CustomerGameAppEntity selectByGameIdAndCustomerIdAndappId(Long gameId, Long customerId, Long appId) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("gameId", gameId);
		params.put("customerId", customerId);
		params.put("appId", appId);
		return selectOne("selectByGameIdAndCustomerIdAndappId",params);
	}

	@Override
	public int updateRecod(Long gameId, Long customerId, Long appId,Long bestRecord, Long rank) {
			Map<String, Object> params = Maps.newHashMap();
			params.put("gameId", gameId);
			params.put("customerId", customerId);
			params.put("appId", appId);
			params.put("bestRecord", bestRecord);
			params.put("rank", rank);
	      return update("updateRecod",params);
	}

	@Override
	public int updateIsBuy(Long gameId, Long customerId, Long appId) {
			Map<String, Object> params = Maps.newHashMap();
			params.put("gameId", gameId);
			params.put("customerId", customerId);
			params.put("appId", appId);
			params.put("isBuy", 1);
	     return update("updateIsBuy",params);
	}
	
}
