package cn.com.duiba.activity.center.biz.dao.plugin.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.plugin.ActivityPluginVistDao;
import cn.com.duiba.activity.center.biz.entity.plugin.ActivityPluginVistEntity;

/** 
 * ClassName:ActivityPluginVistDaoImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年11月1日 下午5:17:03 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Repository
public class ActivityPluginVistDaoImpl extends ActivityBaseDao implements ActivityPluginVistDao {

	@Override
	public ActivityPluginVistEntity createActivityPluginInfo(ActivityPluginVistEntity entity) {
		insert("createActivityPluginInfo", entity);
		return entity;
	}

	@Override
	public Integer updateActivityPluginInfo(Long id, Integer activityType) {
	    Map<String, Object> map = new HashMap<String, Object>();
	    map.put("id", id);
	    map.put("activityType", activityType);
		return update("updateActivityPluginInfo",map);
	}

	@Override
	public ActivityPluginVistEntity findByActivityIdAndType(Long id, Integer activityType) {
	    Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("activityType", activityType);
		return selectOne("findByActivityIdAndType", map);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_ACTIVITY;
	}
}