package cn.com.duiba.activity.center.biz.dao.rob;

import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;
/**
 * 
 * Author ：zhengjy <br/>
 * Create Time：2016年9月30日 上午9:53:36 <br/>
 */
public interface TodayRobSeckillDao {
	
	/**
	 * 查询秒杀区间Dto
	 * @param todayRobSeckillId 秒杀区间id
	 * @return
	 */
	TodayRobSeckillEntity selectSeckillById(Long todayRobSeckillId);
	
	
	
	/**
     * 分页查询秒杀区间列表
     *
     * @param pageNum  第几页
     * @param pageSize 每页展示数量
     * @return
     */
    List<TodayRobSeckillEntity> selectTodayRobSeckillList(int pageNum, int pageSize);
    /**
     * 查询秒杀区间Count
     * @return
     */
    Long selectTodayRobSeckillCount();
	

    /**
     * 删除秒杀区间
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @return
     */
    Boolean deleteTodayRobSeckill(long todayRobSeckillId);
	
	
    /**
     * 停用/启用秒杀区间
     * 启动时，需要扫描秒杀活动是否推送过，没有推送需要推送到开发库
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @param enable  true-启用；false-停用
     * @return
     */
    Boolean updateTodayRobSeckill(long todayRobSeckillId, boolean enable);

    /**
     * 停用指定时间之前的秒杀区间
     *
     * @author zhanglihui
     * @param date  该时间以前的秒杀区间会被停用
     */
    void disableActivityBeforeDate(Date date);
    
    
	 /**
     * 插入秒杀区间
     * @param trc
     */
	Boolean insertSeckill(TodayRobSeckillEntity trc);
	/**
	 * 更新秒杀区间
	 * @author zhengjy
	 * @param trc
	 */
	Boolean updateSeckill(TodayRobSeckillEntity trc);

	/**
	 * 查询指定时间之前的秒杀区间
	 *
	 * @author zhanglihui
	 * @param beforeDate 在指定时间之前
	 * @param limit      指定查询数量
	 * @param showEntrance 秒杀区间展示入口
	 * @return
	 * @since JDK 1.6
	 */
    List<TodayRobSeckillEntity> selectSeckillBeforeTime(Date beforeDate, int limit, String showEntrance);
    
    /**
     * 查询指定时间之后的秒杀区间
     *
     * @author zhanglihui
     * @param afterDate  在指定时间之后
     * @param limit      指定查询数量
     * @param showEntrance 秒杀区间展示入口
     * @return
     * @since JDK 1.6
     */
    List<TodayRobSeckillEntity> selectSeckillAfterTime(Date afterDate, int limit, String showEntrance);


    /**
     * 查询当前开启的秒杀区间
     *
     * @author zhanglihui
     * @return
     * @since JDK 1.6
     */
    List<Long> findEnableTodayRobSeckillIds();
    
}
