package cn.com.duiba.activity.center.biz.dao.rob_category;

import java.util.List;

/**
 * 描述:今日必抢分类栏与分类关联操作dao接口定义
 *
 * @author :sunchangji
 * @create :2016-10-17 13:21
 */
public interface RobBarCategoryRelationDao {

    /**
     * 根据分类栏id查询分类id
     *
     * @param barId 分类栏id
     * @return
     */
    List<Long> getRobCategoryIdsByBarId(Long barId);

    /**
     * 新增
     *
     * @param barId      分类栏id
     * @param categoryId 分类id
     * @param payload    排序值
     * @return
     */
    int insertRobBar(Long barId, Long categoryId, int payload);

    /**
     * 更新
     *
     * @param barId      分类栏id
     * @param categoryId 分类id
     * @param payload    排序值
     * @return
     */
    int updateRobBar(Long barId, Long categoryId, int payload);

    /**
     * 根据分类栏id物理删除
     *
     * @param barId 分类栏id
     * @return
     */
    int deleteByBarId(Long barId);

    /**
     * 根据分类id删除分类栏与分类关联表记录
     *
     * @param categoryId
     * @return
     */
    int deleteByCategoryId(Long categoryId);

    /**
     * 根据分类栏id和分类id物理删除
     *
     * @param barId      分类栏id
     * @param categoryId 分类id
     * @return
     */
    int deleteByBarIdAndCategoryId(Long barId, Long categoryId);
}
