package cn.com.duiba.activity.center.biz.dao.rob_category.impl;

import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.base.RobCategoryBaseDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

/**
 * 描述:今日必抢分类栏dao实现类
 *
 * @author :sunchangji
 * @create :2016-10-17 11:51
 **/
@Repository("robCategoryBarDao")
public class RobCategoryBarDaoImpl extends RobCategoryBaseDao implements RobCategoryBarDao {

	@Override
	public List<RobCategoryBarEntity> getPageByName(String name, Integer offset, Integer pageSize) {
		Map<String, Object> queryMap = this.getQueryMap(3);
		queryMap.put("name", name);
		queryMap.put("offset", offset);
		queryMap.put("pageSize", pageSize);
		return selectList("getPageByName", queryMap);
	}

    @Override
    public List<RobCategoryBarEntity> getByBarIds(List<Long> barIds) {
        Map<String, Object> queryMap = this.getQueryMap(1);
        queryMap.put("barIds",barIds);
        return selectList("getByBarIds",queryMap);
    }

    @Override
	public RobCategoryBarEntity getById(Long id) {
		return selectOne("getById",id);
	}

	@Override
	public int countByName(String name) {
		return selectOne("countByName",name);
	}

	@Override
	public Long insertRobCategoryBar(RobCategoryBarEntity robCategoryBarEntity) {
        insert("insertRobCategoryBar", robCategoryBarEntity);
		return robCategoryBarEntity.getId();
	}

	@Override
	public int updateRobCategoryBar(Long id, String name) {
		Map<String, Object> params = new HashMap<>();
		params.put("id", id);
		params.put("name", name);
		return update("updateRobCategoryBar", params);
	}

	@Override
	public int deleteById(Long id) {
		return delete("deleteById", id);
	}

    @Override
    public List<RobCategoryBarEntity> getAllCategoryBarList() {
        return selectList("getAllCategoryBarList");
    }
}
