/**
 * Project Name:activity-center-biz File Name:GameCenterResourceEntity.java Package
 * Name:cn.com.duiba.activity.center.biz.entity.gamecenter Date:2016年10月20日上午10:09:43 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.entity.gamecenter;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.activity.center.common.dto.BaseEntity;

/**
 * ClassName:GameCenterResourceEntity <br/>
 * Function: 游戏中心资源Dao数据结构. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 上午10:09:43 <br/>
 *
 * @author zhuzhiyong
 * @version
 * @see
 */
public class GameCenterResourceEntity extends BaseEntity implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -8748373947181277864L;

    /** 逻辑主键. */
    private Long              id;

    /** 活动类型. */
    private Integer           activityType;

    /** 活动ID. */
    private Long              activityId;

    /** 资源位ID. */
    private Long              resourceLocationId;

    /** 资源状态. */
    private Byte              status;

    /** 资源优先级. */
    private Integer           payload;

    /** The gmt create. */
    private Date              gmtCreate;

    /** The gmt modified. */
    private Date              gmtModified;

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the new id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the activity type.
     *
     * @return the activity type
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * Sets the activity type.
     *
     * @param activityType the new activity type
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * Gets the activity id.
     *
     * @return the activity id
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * Sets the activity id.
     *
     * @param activityId the new activity id
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * Gets the resource location id.
     *
     * @return the resource location id
     */
    public Long getResourceLocationId() {
        return resourceLocationId;
    }

    /**
     * Sets the resource location id.
     *
     * @param resourceLocationId the new resource location id
     */
    public void setResourceLocationId(Long resourceLocationId) {
        this.resourceLocationId = resourceLocationId;
    }

    /**
     * Gets the status.
     *
     * @return the status
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * Sets the status.
     *
     * @param status the new status
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * Gets the payload.
     *
     * @return the payload
     */
    public Integer getPayload() {
        return payload;
    }

    /**
     * Sets the payload.
     *
     * @param payload the new payload
     */
    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    /**
     * Gets the gmt create.
     *
     * @return the gmt create
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * Sets the gmt create.
     *
     * @param gmtCreate the new gmt create
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * Gets the gmt modified.
     *
     * @return the gmt modified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * Sets the gmt modified.
     *
     * @param gmtModified the new gmt modified
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * TODO 简单描述该方法的实现功能（可选）.
     *
     * @return the string
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "GameCenterResourceEntity [id=" +
                id +
                ", activityType=" +
                activityType +
                ", activityId=" +
                activityId +
                ", resourceLocationId=" +
                resourceLocationId +
                ", status=" +
                status +
                ", payload=" +
                payload +
                ", gmtCreate=" +
                gmtCreate +
                ", gmtModified=" +
                gmtModified +
                "]";
    }

}
