package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.exception.DeveloperAddFailedException;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerSignService;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.sign.SignFlowInnerService;
import cn.com.duiba.activity.center.biz.sign.event.SignEventsDispatcher;
import cn.com.duiba.activity.center.biz.sign.event.credits.AddCreditsFailEvent;
import cn.com.duiba.activity.center.biz.support.RedisKeyFactory;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duiba.wolf.utils.DateUtils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/** 
 * ClassName:ConsumerSignServiceImpl.java <br/>
 * @author  ly
 * @date 创建时间：2016年11月05日 下午4:53:14 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class ConsumerSignServiceImpl implements ConsumerSignService {
	
	private static Logger log = LoggerFactory.getLogger(ConsumerSignServiceImpl.class);
	@Autowired
	private RemoteActivityOrderService remoteActivityOrderService;
	@Autowired
	private RemoteConsumerService remoteConsumerService;
	@Autowired
	private ActivityPrizeOptionService activityPrizeOptionService;
	@Autowired
	private SignFlowInnerService signFlowInnerService;
	@Autowired
    private RedisClient redisClient;
	@Autowired @Qualifier("notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
	
	@Override
	public void asyncConsumerPlug(Long appId, Long consumerId, String orderNum,
			String transfer, String ip,String ua,
			String os, SignConfigDto signDto, Integer signDays) throws Exception {

		//查询订单
		DubboResult<ActivityOrderDto> order = remoteActivityOrderService.findByOrderNum(orderNum);
		if(!order.isSuccess() || order.getResult() == null){
			CreditsCallbackMessage message = new CreditsCallbackMessage();
			message.setAppId(order.getResult().getAppId().toString());
			message.setRelationId(order.getResult().getOrderNum());
			message.setRelationType(order.getResult().getActivityType());
			Map<String,String> params = Maps.newHashMap();
			params.put("ip", ip);
			message.setParams(params);
			onCreditsFail(message,new Exception("订单号不存在"));
			return;
		}
		
		CreditsCallbackMessage message = new CreditsCallbackMessage();
		message.setAppId(order.getResult().getAppId().toString());
		message.setRelationId(order.getResult().getOrderNum());
		message.setRelationType(order.getResult().getActivityType());
		Map<String,String> params = Maps.newHashMap();
		params.put("ip", ip);
		message.setParams(params);
		
		// 加积分失败
		//remoteActivityOrderService.addCreditsFail(orderNum, null, null, null, null, null, null, null, null, null, "签到加积分失败", "签到加积分失败", "签到加积分失败");
		//throw new Exception("签到加积分失败");
		// 向redis里面缓存数据
		String key = RedisKeyFactory.getConsumerTodaySignKey(appId, consumerId);
		redisClient.set(key, "1", "nx", "ex", getDistanceTimes(DateUtils.daysAddOrSub(new Date(), 1)));
		onCreditsSuccess(message,ua,os,signDto, signDays);
	}
	
	private static long getDistanceTimes(Date dateAdd) {  
	    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one;  
        Date two;  
        long day = 0;  
        long hour = 0;  
        long min = 0; 
        long sec = 0;  
        try {  
            one = new Date();  
            two = df.parse(df.format(dateAdd));  
            long time1 = one.getTime();  
            long time2 = two.getTime();  
            long diff ;  
            if(time1<time2) {  
                diff = time2 - time1;  
            } else {  
                diff = time1 - time2;  
            }  
            sec = (diff/1000-day*24*60*60-hour*60*60-min*60);  
        } catch (Exception e) {  
            e.printStackTrace();  
        }  
        return sec;  
    } 
	/**
	 * 生成订单失败
	 * onCreditsFail:(这里用一句话描述这个方法的作用). <br/>
	 * @author gey
	 * @param message
	 * @param exception
	 * @since JDK 1.6
	 */
	private void onCreditsFail(CreditsCallbackMessage message,Exception exception) {
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
		try {
			ActivityOrderDto o4u = new ActivityOrderDto();
			if ((exception instanceof DeveloperAddFailedException) && ((DeveloperAddFailedException) exception).getNormalFail()) {
				o4u.setError4admin("加积分失败，开发者返回扣积分失败。" + exception.getMessage());
				o4u.setError4developer("加积分失败，开发者返回扣积分失败。");
				o4u.setError4consumer("抽奖失败，请稍后再试。");
			} else {
				o4u.setError4admin("加积分失败，开发者服务器异常。" + exception.getMessage());
				o4u.setError4developer("加积分失败，" + exception.getMessage());
				o4u.setError4consumer("抽奖失败，请稍后再试。");
			}
			remoteActivityOrderService.addCreditsFail(order.getOrderNum(),null, null, 
														  null, null, null, null, null, null, null,
														  o4u.getError4admin(),o4u.getError4developer(),o4u.getError4consumer());
		} catch (Exception e) {
			log.error("活动抽奖异常:", e);
		} finally {
			complete(order.getOrderNum());
			// 发出加积分失败事件
            SignEventsDispatcher.get().dispatchAddCreditsFailEvent(new AddCreditsFailEvent(order, exception));
		}
	}

	private void complete(String orderNum) {
		// 查询最新订单信息
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
		// 通知开发者
        insertAddCreditsOrderNotifyQueueIfNesscery(order);
		// 发出活动订单事件
		if (order.getAddCreditsStatus() == ActivityOrderDto.AddCreditsSuccess) {
			SignEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderSuccess, order));
		} else if (order.getAddCreditsStatus() == ActivityOrderDto.AddCreditsFail) {
			SignEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderFail, order));
		}
	}
	
	private void insertAddCreditsOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getAddCredits() <= 0) {
                return;
            }
            if (order.getAddCreditsStatus() == ActivityOrderDto.AddCreditsProcessing) {
                return;
            }
            ConsumerDO consumer=remoteConsumerService.find(order.getConsumerId());
            
            NotifyQueueDO nq=new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType(NotifyQueueDO.RTActivitySign);
            nq.setTimes(0);
            nq.setResult(order.getAddCreditsStatus() == ActivityOrderDto.AddCreditsSuccess);
            notifyQueueDAO.insert(nq);
            notifyCenterServiceClient.notifyImmediately(nq.getId());
        } catch (Exception e) {
            log.error("insertAddCreditsOrderNotifyQueueIfNesscery error",e);
        }
    }
	
	private void onCreditsSuccess(CreditsCallbackMessage message, String ua,String os,SignConfigDto signDto, Integer signDays) {
		String ip = message.getParams().get("ip");
		ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
		List<ActivityPrizeOptionDto> options = Lists.newArrayList();
		//查询奖项
		if(ActivityOrderDto.TypeSign.equals(order.getActivityType())){
		    if(SignConfigDto.TYPE_CIRCLE == signDto.getSignType()) {
		        if(StringUtils.isNotBlank(signDto.getSignCredits())) {
    		        String[] signCredits = signDto.getSignCredits().split(",");
    		        signDays = signDays % signCredits.length;
    		        if(signDays==0) {
    		            signDays = signCredits.length;
    		        }
		        }
		    }
			options = activityPrizeOptionService.queryActivityOptionsByConfigIdAndDays(order.getDuibaActivityId(),ActivityPrizeOptionDto.Activity_Type_Sign, signDays.toString());
		} 
		//根据概率选取一个奖项
		ActivityPrizeOptionDto winOption = signFlowInnerService.randomPrize(order.getDuibaActivityId(),order.getActivityType(), options);

		try{
			//奖项配置与属性的验证
			winOption = signFlowInnerService.winOptionCheck(order,winOption,options);
			signFlowInnerService.doWinPrize(order, winOption, options,ip,ua,os,signDto);
			
		}catch(Exception e){
			log.error("抽奖异常:福袋，若奖项没有配置福袋则中 谢谢参与", e);
			LogUtil.logTodayKan("ConsumerPluginServiceImpl onCreditsSuccess 根据概率选取的一个奖项 winOption===>"+JSONObject.toJSONString(winOption));
			try{
			    winOption = signFlowInnerService.awardThanks(order.getDuibaActivityId(), order.getActivityType());
			    // 无状态的更新状态
			    remoteActivityOrderService.addCreditsSuccess(order.getOrderNum(),winOption.getId(),winOption.getDescription(),
			                                                 winOption.getPrizeType(),winOption.getFacePrice(),winOption.getAppItemId(),
			                                                 winOption.getItemId(),winOption.getgId(),winOption.getgType(),null);
			}catch(Exception e1){
				log.error("抽奖异常,降级为优惠券出错:",e1);
			}
		}finally{
			this.complete(order.getOrderNum());
		}
	}
}
