package cn.com.duiba.activity.center.biz.remoteservice.impl.direct;

import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.api.remoteservice.direct.RemoteDuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by suyuanlong on 16/7/20.
 */
@Service
public class RemoteDuibaActivityAppSpecifyNewServiceImpl implements RemoteDuibaActivityAppSpecifyNewService {


    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;

    @Override
    public DubboResult<DuibaActivityAppSpecifyNewDto> findAppSpecifyByActivityIdAndAppIdAndActivityType(Long activityId, Long appId, String activityType) {

        DuibaActivityAppSpecifyNewDto dto = duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(activityId, appId, activityType);

        if (null != dto) {
            return DubboResult.successResult(dto);
        } else {
            return DubboResult.successResult(null);
        }
    }

    @Override
    public DubboResult<List<DuibaActivityAppSpecifyNewDto>> findAppSpecifyByActivityIdAndActivityType(Long activityId, String type) {

        List<DuibaActivityAppSpecifyNewDto> list = duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndActivityType(activityId, type);

        if (null != list) {
            return DubboResult.successResult(list);
        } else {
            return DubboResult.successResult(null);
        }
    }

    @Override
    public DubboResult insertAppSpecify(DuibaActivityAppSpecifyNewDto specifyBto) {

        Long ret = duibaActivityAppSpecifyNewService.insertAppSpecify(specifyBto);
        if (null == ret) {
            return DubboResult.successResult(null);
        }
        if (ret.equals(-1L)) {
            DubboResult result= DubboResult.successResult(-1L);
            result.setReturnCode("-1");
            result.setMsg("activity_type is error");
            return result;
        }

        if (ret.equals(-2L)) {
            DubboResult result= DubboResult.successResult(-2L);
            result.setReturnCode("-2");
            result.setMsg("hd_type is not exisit");
            return result;
        }

        return DubboResult.successResult(specifyBto.getId());
    }

    @Override
    public DubboResult<Boolean> deleteAppSpecifyById(Long id) {

        int ret = duibaActivityAppSpecifyNewService.deleteAppSpecifyById(id);
        if (ret >= 1) {
          return   DubboResult.successResult(true);
        } else {
          return   DubboResult.successResult(false);
        }


    }

    @Override
    public DubboResult<DuibaActivityAppSpecifyNewDto> findAppSpecifyById(Long id) {

        DuibaActivityAppSpecifyNewDto dto = duibaActivityAppSpecifyNewService.findAppSpecifyById(id);

        if (null != dto) {
            return DubboResult.successResult(dto);
        } else {
            return DubboResult.successResult(null);
        }

    }

    @Override
    public DubboResult<Boolean> isNotAppSpecifyByActivityIdAndAppIdAndActivityType(Long activityId, Long appId, String activityType) {
        DuibaActivityAppSpecifyNewDto dto = duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(activityId, appId, activityType);

        if (null != dto) {
            return DubboResult.successResult(true);
        } else {
            return DubboResult.successResult(false);
        }
    }
    @Override
    public DubboResult<List<Long>> notInappSpecifyActivitys(List<DuibaActivityAppSpecifyNewDto> paras) {
        List<Long> rst = new ArrayList<Long>();
        for(DuibaActivityAppSpecifyNewDto para :paras){
            DuibaActivityAppSpecifyNewDto dto = duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(para.getRelationId(), para.getAppId(), para.getRelationType());
            if (null == dto) {
                rst.add(para.getRelationId());
            }
        }
        return DubboResult.successResult(rst);
    }
}
