package cn.com.duiba.activity.center.biz.remoteservice.impl.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppSaveResultDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.remoteservice.elasticgifts.RemoteElasticGiftsAppBackendService;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("remoteElasticGiftsAppBackendService")
public class RemoteElasticGiftsAppBackendServiceImpl implements RemoteElasticGiftsAppBackendService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemoteElasticGiftsAppBackendServiceImpl.class);

    @Autowired
    private ElasticGiftsAppService elasticGiftsAppService;

    @Override
    public DubboResult<List<ElasticGiftsAppListDto>> getAllElasticGiftsApps(ElasticGiftsBizCodeEnum bizCode, Long activityId) {
        try {
            List<ElasticGiftsAppListDto> result = elasticGiftsAppService.getAllElasticGiftsApps(bizCode, activityId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getAllElasticGiftsApps error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> delete(ElasticGiftsBizCodeEnum bizCode, List<Long> appIds) {
        try {
            Boolean result = elasticGiftsAppService.delete(bizCode, appIds);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("delete error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ElasticGiftsAppSaveResultDto>> save(List<Long> toDeleteIds, ElasticGiftsBizCodeEnum bizCode, List<Long> appIds, Long activityId) {
        try {
            List<ElasticGiftsAppSaveResultDto> result = elasticGiftsAppService.save(toDeleteIds, bizCode, appIds, activityId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("save error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> saveElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, ElasticGiftsBizCodeEnum bizCode) {
        try {
            Boolean result = elasticGiftsAppService.saveElasticGiftsIdByAppId(elasticGiftsId, appId, bizCode);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("saveElasticGiftsIdByAppId error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
