package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameOptionsDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame.RemoteDuibaNgameOptionsService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameOptionsService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class RemoteDuibaNgameOptionsServiceImpl implements RemoteDuibaNgameOptionsService {
    @Resource
    private DuibaNgameOptionsService duibaNgameOptionsService;

    @Override
    public List<DuibaNgameOptionsDto> findByGameId(Long duibaNgameId) {
        return duibaNgameOptionsService.findByGameId(duibaNgameId);
    }

    public Map<Long, List<DuibaNgameOptionsDto>> findByGameIds(List<Long> duibaNgameIds){
        return duibaNgameOptionsService.findByGameIds(duibaNgameIds);
    }

    @Override
    public void addBatch(List<DuibaNgameOptionsDto> list) {
        duibaNgameOptionsService.addBatch(list);
    }

    @Override
    public DuibaNgameOptionsDto add(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        duibaNgameOptionsService.add(duibaNgameOptionsDto);
        return duibaNgameOptionsDto;
    }

    @Override
    public void delete(Long id) {
        duibaNgameOptionsService.delete(id);
    }

    @Override
    public void update(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        duibaNgameOptionsService.update(duibaNgameOptionsDto);
    }

    @Override
    public Integer countBigPrizeByGameId(Long duibaNgameId) {
        return duibaNgameOptionsService.countBigPrizeByGameId(duibaNgameId);
    }

    @Override
    public DuibaNgameOptionsDto find(Long id) {
        return duibaNgameOptionsService.find(id);
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpen(Long ngameId, boolean autoOpen) {
        return duibaNgameOptionsService.findByAutoOpen(ngameId, autoOpen);
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpenDesc(Long ngameId, boolean autoOpen) {
        return duibaNgameOptionsService.findByAutoOpenDesc(ngameId, autoOpen);
    }

    @Override
    public List<DuibaNgameOptionsDto> findDisplayOption(Long ngameId) {
        return duibaNgameOptionsService.findDisplayOption(ngameId);
    }
}
