/**
 * Project Name:activity-center-biz
 * File Name:RemoteSignConfigServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.sign
 * Date:2016年10月22日下午2:20:05
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.sign;

import java.util.List;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.activity.center.api.remoteservice.sign.RemoteSignConfigService;
import cn.com.duiba.activity.center.biz.service.sign.SignConfigService;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName:RemoteSignConfigServiceImpl <br/>
 * Date:     2016年10月22日 下午2:20:05 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteSignConfigServiceImpl implements RemoteSignConfigService {
    
    private static Logger log = LoggerFactory.getLogger(RemoteSignConfigServiceImpl.class);
    
    @Resource
    private SignConfigService signConfigService;

    @Override
    public List<SignConfigDto> findAllByIds(List<Long> ids) {
        return signConfigService.findAllByIds(ids);
    }

    @Override
    public List<SignConfigDto> findByPage(Long appId, Integer offset, Integer max, String title, Integer id) {
        return signConfigService.findByPage(appId, offset, max, title, id);
    }

    @Override
    public Long findByPageCount(Long appId, String title, Integer id) {
        return signConfigService.findByPageCount(appId, title, id);
    }

    @Override
    public SignConfigDto find(Long id) {
        return signConfigService.find(id);
    }

    @Override
    public SignConfigDto add(SignConfigDto sign) {
        return signConfigService.add(sign);
    }

    @Override
    public void delete(Long id) {
        signConfigService.delete(id);
    }

    @Override
    public void update(SignConfigDto sign) {
        signConfigService.update(sign);
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        return signConfigService.updateStatus(id, status);
    }

    @Override
    public DubboResult<String> createOrder(Long consumerId, String transfer, String ip, String description, String ua,
                                           String os, SignConfigDto signDto, Integer signDays, Long addCredits) {
        //产生订单号
        try{
            String orderNum = signConfigService.createOrder(consumerId,transfer,ip,description,ua,os,signDto, signDays, addCredits);
            return DubboResult.successResult(orderNum);
        }catch (Exception e){
            log.error("订单生成失败",e);
            if(e instanceof StatusException){
                return DubboResult.failResult(((StatusException)e).getMessage());
            }else{
                return DubboResult.failResult(e.getMessage());
            }
        }
    }
    
    @Override
    public DubboResult<String> addCreditsAgain(String orderNum, Long appId, Long consumerId, String transfer, String ip, String description, String ua,
                                           String os, SignConfigDto signDto, Integer signDays, Long addCredits) {
        try{
            signConfigService.addCreditsAgain(orderNum, appId, consumerId,transfer,ip,description,ua,os,signDto, signDays, addCredits);
            return DubboResult.successResult(orderNum);
        }catch (Exception e){
            log.error("订单生成失败",e);
            if(e instanceof StatusException){
                return DubboResult.failResult(((StatusException)e).getMessage());
            }else{
                return DubboResult.failResult(e.getMessage());
            }
        }
    }
}

