package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.biz.dao.singlelottery.DuibaSingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.DuibaSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 单品抽奖.
 */
@Service("duibaSingleLotteryToolServiceImpl")
public class DuibaSingleLotteryToolServiceImpl extends ActivityToolService.ActivityToolServiceAdapter {

    @Autowired
    private DuibaSingleLotteryDao duibaSingleLotteryDao;

    @Override
    public String getTitle(Long activityId) {
        if (activityId == null) {
            throw new RuntimeException("参数不全");
        }
        DuibaSingleLotteryEntity entity = duibaSingleLotteryDao.find(activityId);
        if (entity == null || entity.getDeleted()) {
            throw new RuntimeException("活动不存在");
        }
        return entity.getTitle();
    }

}
