/**
 * Project Name:activity-center-biz File Name:GameCenterShieldService.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter Date:2016年10月20日下午1:49:26 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;

/**
 * ClassName:GameCenterShieldService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午1:49:26 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface ActivityShieldService {

    /**
     * addShield:屏蔽活动. <br/>
     *
     * @author zhuzhiyong
     * @param shieldItemDto the shield item dto
     * @return the boolean
     * @since JDK 1.6
     */
    Long addShield(ShieldItemDto shieldItemDto);

    /**
     * removeShield:还原屏蔽. <br/>
     * id为逻辑主键
     * 
     * @author zhuzhiyong
     * @param ids the ids
     * @return the boolean
     * @since JDK 1.6
     */
    Boolean removeShield(Long shieldId);

    /**
     * findShieldByAppId:根据主键id查询屏蔽记录. <br/>
     *
     * @author zhuzhiyong
     * @param id the id
     * @return the list
     * @since JDK 1.6
     */
    ShieldItemDto find(Long id);

    /**
     * Find shield.
     *
     * @param appId the app id
     * @param activityType the activity type
     * @param activityId the activity id
     * @return the activity shield entity
     */
    boolean isExist(Long appId, Integer activityType, Long activityId);

    /**
     * 根据appId，activityType和activityId组合查询屏蔽记录.
     *
     * @param appId APP ID
     * @param activityType 活动类型，可以是小游戏，或者其他游戏，常量定义见{@code DefinedActivityTypesDto}
     * @param activityIds the activity ids
     * @param useCache 是否使用cache
     * @return the activity shield entity
     */
    List<ActivityShieldEntity> findShields(Long appId, Integer activityType, Set<Long> activityIds, boolean useCache);

    /**
     * findShieldList:查询屏蔽列表，支持分页，支持按指定字段过滤. <br/>
     * 分页参数：offset, max <br>
     * 支持单独参数过滤：appId <br>
     * 支持组合参数过滤：appId & activityType <br>
     *
     * @author zhuzhiyong
     * @param paramMap the param map
     * @return the list
     */
    List<ShieldItemDto> findShieldList(Map<String, Object> paramMap);

    /**
     * countShield:查询指定条件的记录数. <br/>
     * 支持单独参数过滤：appId <br>
     * 支持组合参数过滤：appId & activityType <br>
     *
     * @param paramMap the param map
     * @return the integer
     */
    Integer countShield(Map<String, Object> paramMap);
}
