/**
 * Project Name:activity-center-biz File Name:GameCenterHomeServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月21日下午1:55:51 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.gamecenter.DefinedActivityTypesDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.service.domain.dataobject.EmbedDO;

/**
 * ClassName:GameCenterHomeServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月21日 下午1:55:51 <br/>
 * 
 * @author zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class GameCenterHomeServiceImpl implements GameCenterHomeService {

    @Autowired
    private GameCenterResourceDao  gameCenterResourceDao;
    @Autowired
    private GameCenterCommonSerice gameCenterCommonSerice;

    @Override
    public GameCenterHomeResourceListDto findResourceByLocationAndAppId(String locationName, Long appId, Integer offset,
                                                                        Integer max) throws GameCenterException {
        GameCenterHomeResourceListDto gameCenterHomeResourceListDto = new GameCenterHomeResourceListDto();
        List<GameCenterResourceEntity> entities = gameCenterResourceDao.findResourceByLocationId(gameCenterCommonSerice.findLocationIdByName(locationName));
        if (CollectionUtils.isEmpty(entities)) {
            return gameCenterHomeResourceListDto;
        }

        List<GameCenterHomeResourceDto> gameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        GameCenterHomeResourceDto temp;

        Long developerId = gameCenterCommonSerice.findDeveloperIdByAppId(appId);
        if (developerId == null) {
            return gameCenterHomeResourceListDto;
        }

        Set<Long> littleGameIds = new HashSet<Long>();
        for (GameCenterResourceEntity gameCenterResourceEntity : entities) {
            if (gameCenterResourceEntity.getActivityType() == DefinedActivityTypesDto.LITTLE_GAME) {
                littleGameIds.add(gameCenterResourceEntity.getActivityId());

                temp = new GameCenterHomeResourceDto();
                temp.setActivityId(gameCenterResourceEntity.getActivityId());
                temp.setActivityType(gameCenterResourceEntity.getActivityType());
                temp.setGmtCreate(gameCenterResourceEntity.getGmtCreate());
                temp.setGmtModified(gameCenterResourceEntity.getGmtModified());
                temp.setLocationId(gameCenterResourceEntity.getResourceLocationId());
                // 埋点细节设置为小游戏
                temp.setInfoType(EmbedDO.InfoType_LittleGame);
                temp.setInfo(gameCenterResourceEntity.getActivityId());
                // 小游戏链接
                temp.setLink("/littleGame/start?littleGameId="
                             + String.valueOf(gameCenterResourceEntity.getActivityId())
                             + "&startSource=null&dbnewopen");
                gameCenterHomeResourceDtoList.add(temp);
            }
        }
        Map<Long, LittleGameEntity> littleGameEntityMap = gameCenterCommonSerice.buildLittleGameEntityMap(littleGameIds);
        if (littleGameEntityMap.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }

        Map<Long, ActivityShieldEntity> activityShieldEntityMap = gameCenterCommonSerice.buildActivityShieldEntityMap(appId,
                                                                                                                      littleGameIds,
                                                                                                                      true);

        List<GameCenterHomeResourceDto> finalGameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        LittleGameEntity littleGameEntity;
        for (GameCenterHomeResourceDto item : gameCenterHomeResourceDtoList) {
            littleGameEntity = littleGameEntityMap.get(item.getActivityId());
            if (Utils.filterLittleGameByStatus(littleGameEntity)) {
                continue;
            }
            // 开启了黑名单，并且在黑名单中
            if (gameCenterCommonSerice.filterByActivityBlacklist(littleGameEntity, developerId)) {
                continue;
            }
            // 开启了定向,但app不在定向范围内
            if (gameCenterCommonSerice.filterBySpecify(littleGameEntity, appId)) {
                continue;
            }
            if (null != activityShieldEntityMap.get(item.getActivityId())) {
                continue;
            }
            item.setTitle(littleGameEntity.getLittleGameTitle());
            item.setDescription(littleGameEntity.getLittleGameRecomDescribe());
            item.setBannerImg(littleGameEntity.getLittleGameBannerImg());
            item.setRecommendImg(littleGameEntity.getLittleGameSmallImg()); // 使用缩略图
            item.setIconImg(littleGameEntity.getLittleGameIconImg());
            finalGameCenterHomeResourceDtoList.add(item);
        }

        if (finalGameCenterHomeResourceDtoList.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }

        // 根据修改时间倒序
        Collections.sort(finalGameCenterHomeResourceDtoList, new Comparator<GameCenterHomeResourceDto>() {

            @Override
            public int compare(GameCenterHomeResourceDto o1, GameCenterHomeResourceDto o2) {
                return o2.getGmtModified().compareTo(o1.getGmtModified());
            }
        });

        gameCenterHomeResourceListDto.setCount(finalGameCenterHomeResourceDtoList.size());
        gameCenterHomeResourceListDto.setGameCenterHomeResourceDtoList(Utils.subList(finalGameCenterHomeResourceDtoList,
                                                                                     offset, max));
        return gameCenterHomeResourceListDto;
    }

}
