/**
 * Project Name:activity-center-biz File Name:Utils.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter.impl Date:2016年10月25日下午4:39:31 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;

/**
 * ClassName:Utils <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月25日 下午4:39:31 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
class Utils {

    private Utils() {
    }

    public static <T> List<T> subList(List<T> list, Integer offset, Integer max) {
        int size = list.size();
        int offsetVal = offset.intValue(), endIdx = offsetVal + max.intValue();
        if (offset.intValue() > size) {
            return Collections.emptyList();
        } else {
            // 截取list
            return endIdx > size ? list.subList(offsetVal, size) : list.subList(offsetVal, endIdx);
        }
    }

    public static boolean filterLittleGameByStatus(LittleGameEntity littleGameEntity) {
        if (littleGameEntity == null) {
            return true;
        }

        // 删除态或者未开启的小游戏过滤掉
        if (littleGameEntity.getLittleGameDelete().booleanValue() || littleGameEntity.getLittleGameStatus() != 1) {
            return true;
        }
        return false;
    }

    public static Date latter(Date one, Date another) {
        return one.compareTo(another) > 0 ? one : another;
    }
}
