package cn.com.duiba.activity.center.biz.service.guess.impl;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessOptionsDto;
import cn.com.duiba.activity.center.biz.dao.guess.DuibaGuessOptionsDao;
import cn.com.duiba.activity.center.biz.entity.guess.DuibaGuessOptionsEntity;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessOptionsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/26.
 */
@Service
public class DuibaGuessOptionsServiceImpl implements DuibaGuessOptionsService {

    @Autowired
    private DuibaGuessOptionsDao duibaGuessOptionsDao;

    @Override
    public List<DuibaGuessOptionsDto> findByGuessId(Long guessId) {
        return BeanUtils.copyList(duibaGuessOptionsDao.findByGuessId(guessId),DuibaGuessOptionsDto.class);
    }

    @Override
    public DuibaGuessOptionsDto findById(Long id) {
        return BeanUtils.copy(duibaGuessOptionsDao.findById(id),DuibaGuessOptionsDto.class);
    }

    @Override
    public List<DuibaGuessOptionsDto> findByAutoOpen(Long guessId, boolean autoOpen) {
        return BeanUtils.copyList(duibaGuessOptionsDao.findByAutoOpen(guessId,autoOpen),DuibaGuessOptionsDto.class);
    }

    @Override
    public List<DuibaGuessOptionsDto> findByAutoOpenAsc(Long guessId, boolean autoOpen) {
        return BeanUtils.copyList(duibaGuessOptionsDao.findByAutoOpenAsc(guessId,autoOpen),DuibaGuessOptionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        return duibaGuessOptionsDao.delete(ids);
    }

    @Override
    public void insert(DuibaGuessOptionsDto duibaGuessOptionsDto) {
        DuibaGuessOptionsEntity entity=BeanUtils.copy(duibaGuessOptionsDto,DuibaGuessOptionsEntity.class);
        duibaGuessOptionsDao.insert(entity);
        duibaGuessOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateInfoForm(DuibaGuessOptionsDto duibaGuessOptionsDto) {
        return duibaGuessOptionsDao.updateInfoForm(BeanUtils.copy(duibaGuessOptionsDto,DuibaGuessOptionsEntity.class));
    }

    /**
     * 更新库存
     *
     * @param id
     * @param remaining
     */
    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return duibaGuessOptionsDao.updateRemainingById(id,remaining);
    }
}
