package cn.com.duiba.activity.center.biz.service.luckbag;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagCallback.LuckBagFlowWorker;
import cn.com.duiba.activity.center.biz.service.plugin.PluginFlowInnerService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.dcommons.flowwork.ActivityPluginFlowworkService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.EmbedDO;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.service.IEngineService;

import com.alibaba.fastjson.JSONObject;

@Component("luckBagFlowWorker")
public class LuckBagFlowWorkerImpl implements LuckBagFlowWorker{
	
	private static Logger log = LoggerFactory.getLogger(LuckBagFlowWorkerImpl.class);
	@Autowired
	private ActivityPluginFlowworkService activityPluginFlowworkService;
	@Autowired
	private XMemCacheClient memCacheClient;
	@Autowired
	private RemoteActivityOrderService remoteActivityOrderService;
	@Autowired
	private IEngineService iEngineService;
	@Autowired
	private PluginFlowInnerService pluginFlowInnerService;
	
	/**
	 * 发起异步请求
	 * @throws Exception 
	 */
	@Override
	public void asyncHttpRequest(String orderId,Long consumerId,Long operatingAcitivityId,Long appId,String ip,String ua, String tag,String buttonType,String infoType,String info,String os,String userAgent,
			List<ActivityPrizeOptionDto> options, ActivityPluginDto pluDto) throws Exception{
		LuckBagRequest req = LuckBagRequest.buildRequestData(ActivityOrderDto.TypePlugin+"_" +orderId, consumerId,operatingAcitivityId,appId,ip,ua,null,tag,os,options,pluDto);
		LuckBagRequestServer(req,new LuckBagCallBackResponse(orderId, consumerId,operatingAcitivityId,null,req),buttonType,infoType,info,os,userAgent);
	}
	
	public static String getUA(String userAgent){
        if(userAgent==null){
            return "unknown";
        }
        userAgent=userAgent.toLowerCase();
        if(userAgent!=null){
            if(userAgent.contains("ipad")){
                return "IOS";
            }else if(userAgent.contains("iphone")){
                return "IOS";
            }else if(userAgent.contains("android")){
                return "Android";
            }else if(userAgent.contains("macintosh")){
                return "IOS";
            }
        }
        return "unknown";
    }

	private void LuckBagRequestServer(final LuckBagRequest req,final LuckBagCallback callback,String buttonType,String infoType,String info,String os,String userAgent) throws Exception{
		ObtainAdvertReq obtain = new ObtainAdvertReq();
		obtain.setConsumerId(req.getConsumerId());
		obtain.setUa(getUA(req.getUa()));
		obtain.setOrderId(req.getOrderId());
		obtain.setIp(req.getIp());
		obtain.setAppId(req.getAppId());
		obtain.setActivityId(req.getOperatingActivityId());
		obtain.setTimestamp(new Date().getTime());
		obtain.setTag(req.getTag());
		//1 登录  0 未登录
		obtain.setLoginType(EmbedDO.LoginType);
		//按钮埋点号码 
		obtain.setButtonType(buttonType);
		//细节类型
		obtain.setInfoType(infoType);
		//细节
		obtain.setInfo(info);
		//os
		obtain.setOs(os);
		//点击：0，曝光：1，请求：2，发券：3，计费：4
		obtain.setType("2");
		//用户ua
		obtain.setUserAgent(userAgent);
		//插件活动为1   其他为null
		obtain.setActivityType(1);
		
		ObtainAdvertRsp advert = null;
		try{
			advert = iEngineService.obtainAdvert(obtain);
			if(null == advert || !advert.isResult() ){
				LogUtil.logPluginKan("===============》    广告平台获取卷异常");
				callback.onException(new Exception("广告平台获取卷异常"));
				return;
			}
			callback.onFinish(advert);
		}catch(Exception e){
			log.error("es submit obtain advert error",e);
			callback.onException(e);
		}
	}

	private class LuckBagCallBackResponse implements LuckBagCallback{

		private String orderId;//抽奖订单id
		private Long activityId;//活动
		private LuckBagRequest req;

		public LuckBagCallBackResponse(String orderId,Long consumerId,Long activityId,Long orderExtraId,LuckBagRequest req){
			this.orderId = orderId;
			this.activityId = activityId;
			this.req = req;
		}
		
		@Override
		public void onFinish(ObtainAdvertRsp advert) throws Exception {
			//正常中福袋
			if(null == advert){
				onException(new Exception("获取福袋失败"));
				return;
			}
			//创建兑换记录
			ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderId).getResult();
			activityPluginFlowworkService.insertCosumerExchanageRecord(req.getConsumerId(),orderId,advert.getEndValid(),order.getActivityOptionType());
			//福袋中奖信息存入缓存,10秒过期
			memCacheClient.getMemcachedClient().set(getMemKey(orderId), 10, JSONObject.toJSONString(advert));
			//订单置为领奖成功
			remoteActivityOrderService.exchangeStatusToSuccess(orderId);
			LogUtil.logPluginKan("===============》    福袋领奖成功");

		}

		@Override
		public void onException(Exception ex) throws Exception {
			LogUtil.logPluginKan("===============》    福袋领奖异常     orderId："+orderId);
			ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderId).getResult();
			ActivityPrizeOptionDto option =pluginFlowInnerService.awardThanks(activityId, order.getActivityType());
			LogUtil.logPluginKan("===============》    福袋领奖异常   奖品降级为谢谢参与  orderId："+orderId);
			// 更新订单中奖信息
			remoteActivityOrderService.consumeCreditsSuccessDowngrade(order.getOrderNum(),option.getId(),option.getPrizeName(),
					option.getPrizeType(),option.getFacePrice(),option.getAppItemId(),option.getItemId(),option.getgId(),option.getgType(),null);
		}
		
		private String getMemKey(String orderId){
			return MemcachedSpace.MS_LUCK_BAG_CACHE + "-" + orderId;
		}
	}
}
