package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarAppRelationDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarAppRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarAppRelationService;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 功能描述: 功能描述:分类栏与应用关联表操作接口实现类
 * (也称分类栏定向实体)
 *
 * @author sunchangji
 * @date 2016/10/19
 */
@Service
public class RobCategoryBarAppRelationServiceImpl implements RobCategoryBarAppRelationService {
    private static final Logger log = LoggerFactory.getLogger(RobCategoryBarAppRelationServiceImpl.class);
    @Autowired
    private RobCategoryBarAppRelationDao robCategoryBarAppDao;
    @Autowired
    private RobCategoryBarDao robCategoryBarDao;

    @Override
    public List<RobCategoryBarAppRelationDto> getRobCategoryBarAppList() {
        Multimap<Long, RobCategoryBarAppRelationEntity> barAppMultimap = ArrayListMultimap.create();
        List<RobCategoryBarAppRelationEntity> allList = robCategoryBarAppDao.getAllList();
        List<RobCategoryBarAppRelationDto> dtoList = new ArrayList<>();
        if (CollectionUtils.isEmpty(allList))
            return dtoList;
        for (RobCategoryBarAppRelationEntity entity : allList) {
            Long barId = entity.getBarId();
            barAppMultimap.put(barId, entity);
        }
        List<Long> barIdList = Lists.newArrayList(barAppMultimap.keySet());
        List<RobCategoryBarEntity> robCategoryBarEntityList = robCategoryBarDao.getByBarIds(barIdList);
        if (CollectionUtils.isEmpty(robCategoryBarEntityList)) {
            log.error("分类栏不存在，请检查分类栏与应用关联表中数据与分类栏中数据不一致的原因!,barIdList=" + barIdList);
            return Collections.emptyList();
        }

        return assembleRobCategoryBarAppRelations(robCategoryBarEntityList, barAppMultimap);
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean deleteById(Long barId) {
        int line = robCategoryBarAppDao.deleteByBarId(barId);
        return line > 0;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean batchDeleteById(List<Long> barIds) {
        if (CollectionUtils.isEmpty(barIds))
            return true;
        return robCategoryBarAppDao.batchDeleteByBarId(barIds) > 0;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean batchInsertBarAppRelation(List<RobCategoryBarAppRelationDto> batchList) {
        //批量插入新纪录
        for (RobCategoryBarAppRelationDto robCategoryBarAppRelationDto : batchList) {
            Long barId = robCategoryBarAppRelationDto.getBarId();
            Map<Long, String> appIdAndAppNameMap = robCategoryBarAppRelationDto.getAppIdAndAppNameMap();
            for (Map.Entry<Long, String> entry : appIdAndAppNameMap.entrySet()) {
                RobCategoryBarAppRelationEntity relationEntity = robCategoryBarAppDao.getByAppId(entry.getKey());
                if(relationEntity==null){
                    robCategoryBarAppDao.insert(entry.getKey(), entry.getValue(), barId);
                }
            }
        }
        return true;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean batchUpdateBarAppRelation(List<RobCategoryBarAppRelationDto> batchList) {
        for (RobCategoryBarAppRelationDto relationDto : batchList) {
            Long barId = relationDto.getBarId();
            Map<Long, String> appIdAndAppNameMap = relationDto.getAppIdAndAppNameMap();
            if (CollectionUtils.isEmpty(appIdAndAppNameMap)) {
                log.error("更新定向参数中app数据为空");
                return false;
            }

            for (Map.Entry<Long, String> entry : appIdAndAppNameMap.entrySet()) {
                robCategoryBarAppDao.updateAppIdAndBarId(entry.getKey(), entry.getValue(), barId);
            }
        }
        return true;
    }

    @Override
    @Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
    public Boolean batchDeleteBarAppRelation(List<Long> appIds) {
        for (Long appId : appIds) {
            robCategoryBarAppDao.deleteByAppId(appId);
        }
        return true;
    }

    @Override
    public RobCategoryBarAppRelationEntity getByAppId(Long appId) {
        return robCategoryBarAppDao.getByAppId(appId);
    }

    /**
     * 组装RobCategoryBarAppRelationDto集合数据
     *
     * @param robCategoryBarEntityList 分类栏集合
     * @param barAppMultimap           分类栏与应用中间表全部数据分组后的map集合
     * @return
     */
    private List<RobCategoryBarAppRelationDto> assembleRobCategoryBarAppRelations(List<RobCategoryBarEntity> robCategoryBarEntityList,
                                                                                  Multimap<Long, RobCategoryBarAppRelationEntity> barAppMultimap) {
        List<RobCategoryBarAppRelationDto> relationDtoList = new ArrayList<>(robCategoryBarEntityList.size());
        for (RobCategoryBarEntity robCategoryBarEntity : robCategoryBarEntityList) {
            Long barId = robCategoryBarEntity.getId();
            String barName = robCategoryBarEntity.getName();
            Collection<RobCategoryBarAppRelationEntity> relationEntities = barAppMultimap.get(barId);
            Map<Long, String> appIdAndAppName = new HashMap<>();
            if (!relationEntities.isEmpty()) {
                for (RobCategoryBarAppRelationEntity relationEntity : relationEntities) {
                    appIdAndAppName.put(relationEntity.getAppId(), relationEntity.getAppName());
                }
            }
            relationDtoList.add(new RobCategoryBarAppRelationDto(barId, barName, appIdAndAppName));
        }

        return relationDtoList;
    }

}
