package cn.com.duiba.activity.center.biz.service.seckill;

import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;

public interface SeckillStockService {
	/**
	 * skillId和appId是唯一键，但找出来的库存的结果可能为共享库存和私有库存
	 * @param skillId
	 * @param appId
	 * @return
	 */
	DuibaSeckillStockConfigEntity findStockByUnique(Long skillId, Long appId);
	/**
	 * 请不要用此方法查询库存
	 * @param stockId
	 * @return
	 */
	DuibaSeckillStockConfigEntity findStock(Long stockId);
	
	void consumeStock(Long stockId, Long orderId) throws Exception;
}
